import React from 'react';
import { Provider } from 'react-redux';
import { GluestackUIProvider } from '@gluestack-ui/themed';
import { NavigationContainer } from '@react-navigation/native';
import { createStackNavigator } from '@react-navigation/stack';
import { config } from './gluestack-ui.config';
import { store } from './src/store';
import { ThemeProvider } from './src/contexts/ThemeContext';
import { Box, Text, Button, ButtonText, VStack } from '@gluestack-ui/themed';
import ChatScreen from './src/screens/ChatScreen';

const Stack = createStackNavigator();

function MainScreen({ navigation }: any) {
  return (
    <Box flex={1} bg="$background">
      {/* Header */}
      <Box 
        flexDirection="row" 
        justifyContent="space-between" 
        alignItems="center" 
        p="$4"
        borderBottomWidth={1}
        borderBottomColor="$borderLight200"
      >
        <Box 
          width={40} 
          height={40} 
          borderRadius="$full" 
          bg="$backgroundLight100"
          justifyContent="center"
          alignItems="center"
          borderWidth={1}
          borderColor="$borderLight200"
        >
          <Text fontSize="$lg" color="$textLight900" fontWeight="$bold">
            M
          </Text>
        </Box>
        
        <Text fontSize="$lg" fontWeight="$bold" color="$textLight900">
          Mews AI
        </Text>
        
        <Box 
          width={40} 
          height={40} 
          borderRadius="$full" 
          bg="$backgroundLight100"
          justifyContent="center"
          alignItems="center"
          borderWidth={1}
          borderColor="$borderLight200"
        >
          <Text fontSize="$lg" color="$textLight900" fontWeight="$bold">
            N
          </Text>
        </Box>
      </Box>

      {/* Main Content */}
      <Box flex={1} justifyContent="center" alignItems="center" p="$4">
        <VStack space="lg" alignItems="center">
          <Box 
            width={80} 
            height={80} 
            borderRadius="$full" 
            bg="$primary500"
            justifyContent="center"
            alignItems="center"
          >
            <Text fontSize="$2xl" color="#ffffff" fontWeight="$bold">
              M
            </Text>
          </Box>
          
          <VStack space="sm" alignItems="center">
            <Text size="2xl" fontWeight="$bold" color="$primary500">
              Welcome to Mews AI
            </Text>
            <Text size="md" color="$textLight600" textAlign="center" maxWidth={300}>
              Your intelligent news assistant. Ask me anything about the latest news and get instant, accurate answers.
            </Text>
          </VStack>
          
          <Button
            onPress={() => navigation.navigate('Chat')}
            bg="$primary500"
            borderRadius="$lg"
            px="$8"
            py="$4"
            width="100%"
            maxWidth={300}
          >
            <ButtonText color="#ffffff" fontSize="$lg" fontWeight="$medium">
              Start Chat
            </ButtonText>
          </Button>
        </VStack>
      </Box>
    </Box>
  );
}

export default function App() {
  return (
    <Provider store={store}>
      <GluestackUIProvider config={config}>
        <ThemeProvider>
          <NavigationContainer>
            <Stack.Navigator
              screenOptions={{
                headerShown: false,
              }}
            >
              <Stack.Screen name="Main" component={MainScreen} />
              <Stack.Screen name="Chat" component={ChatScreen} />
            </Stack.Navigator>
          </NavigationContainer>
        </ThemeProvider>
      </GluestackUIProvider>
    </Provider>
  );
}