export interface NewsArticle {
  id: number;
  post_title: string;
  post_excerpt: string;
  post_content: string;
  post_image: string;
  post_category: string;
  post_source: string;
  date_added: string;
  views: number;
}

export interface ChatMessage {
  id: string;
  text: string;
  isUser: boolean;
  timestamp: number;
  news_data?: NewsArticle[];
}

export interface ChatResponse {
  success: boolean;
  message: string;
  news_data?: NewsArticle[];
}

export type RootStackParamList = {
  Main: undefined;
  Chat: undefined;
  Discover: undefined;
  Profile: undefined;
  DeepDive: { articleId: string };
};

export interface ThemeColors {
  background: string;
  surface: string;
  text: string;
  textSecondary: string;
  border: string;
  primary: string;
  accent: string;
}