# Mews Mobile App

A React Native mobile application for the Mews AI-powered news chatbot, built with Expo and TypeScript.

## 🚀 Features

- **AI Chatbot**: Real-time chat with your Laravel backend
- **News Feed**: Browse latest news articles with category filtering
- **Clean Design**: Minimalistic and modern UI
- **Cross-Platform**: Works on both iOS and Android
- **TypeScript**: Type-safe development

## 📱 Getting Started

### Prerequisites

- Node.js (v16 or higher)
- npm or yarn
- Expo CLI (installed automatically)
- Expo Go app on your mobile device

### Installation

1. **Install dependencies:**
   ```bash
   npm install
   ```

2. **Update API configuration:**
   - Open `src/config/api.ts`
   - Update `BASE_URL` with your computer's IP address
   - Find your IP: `ifconfig en0 | grep "inet " | awk '{print $2}'`

3. **Start the development server:**
   ```bash
   npm start
   ```

### Testing the App

1. **On Mobile Device:**
   - Install Expo Go from App Store/Play Store
   - Scan the QR code from the terminal
   - The app will load on your device

2. **On Simulator:**
   - Press `i` for iOS Simulator
   - Press `a` for Android Emulator
   - Press `w` for web browser

## 🔧 Configuration

### API Settings

Update the API configuration in `src/config/api.ts`:

```typescript
export const API_CONFIG = {
  BASE_URL: 'http://YOUR_IP_ADDRESS/mews/public',
  // ... other settings
};
```

### Backend Requirements

Make sure your Laravel backend has these endpoints:
- `POST /chat` - For chatbot interactions
- `GET /api/news` - For fetching news articles (optional, uses sample data if not available)

## 📁 Project Structure

```
src/
├── components/     # Reusable UI components
├── screens/        # App screens (Home, Chat, Profile, etc.)
├── navigation/     # Navigation configuration
├── services/       # API services
├── store/          # Redux store and slices
├── types/          # TypeScript type definitions
├── utils/          # Utility functions
└── config/         # Configuration files
```

## 🎨 Design System

- **Primary Color**: `#0a57d4` (Mews Blue)
- **Secondary Color**: `#2d72f0`
- **Accent Color**: `#5a95ff`
- **Background**: `#fafafa`
- **Text**: `#333` (primary), `#666` (secondary), `#999` (tertiary)

## 🔄 State Management

The app uses Redux Toolkit for state management:

- **Chat State**: Messages, loading states, session management
- **News State**: Articles, categories, filtering
- **User State**: Authentication, profile information

## 📱 Screens

1. **Home Screen**: News feed with category filtering
2. **Chat Screen**: AI chatbot interface
3. **Profile Screen**: User settings and statistics
4. **Article Screen**: Full article reading experience

## 🚀 Development

### Available Scripts

- `npm start` - Start Expo development server
- `npm run android` - Run on Android
- `npm run ios` - Run on iOS
- `npm run web` - Run on web

### Building for Production

```bash
# Build for Android
expo build:android

# Build for iOS
expo build:ios
```

## 🔧 Troubleshooting

### Network Issues

1. **API Connection Errors**: Make sure your IP address is correct in `src/config/api.ts`
2. **CORS Issues**: Ensure your Laravel backend allows requests from your mobile device
3. **Firewall**: Check that your computer's firewall allows connections on the specified port

### Common Issues

1. **Metro bundler issues**: Clear cache with `expo start -c`
2. **Dependencies issues**: Delete `node_modules` and run `npm install`
3. **TypeScript errors**: Run `npx tsc --noEmit` to check for type errors

## 📝 Notes

- The app includes sample data for news articles if the API is not available
- Chat functionality requires your Laravel backend to be running
- The design is optimized for mobile devices with touch interactions
- All API calls include proper error handling and loading states

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test on both iOS and Android
5. Submit a pull request

## 📄 License

This project is part of the Mews application suite.
