// API Configuration
export const API_CONFIG = {
  // Update this to your computer's IP address for mobile testing
  // Find your IP with: ifconfig en0 | grep "inet " | awk '{print $2}'
  BASE_URL: 'http://192.168.100.227/mews/public',
  
  // Alternative URLs for different environments
  // LOCAL: 'http://localhost/mews/public',
  // PRODUCTION: 'https://your-domain.com',
  
  TIMEOUT: 30000,
  
  // Headers
  HEADERS: {
    'Content-Type': 'application/json',
    'Accept': 'application/json',
  },
};

// Helper function to get the correct API URL
export const getApiUrl = () => {
  return API_CONFIG.BASE_URL;
};

// Helper function to update API URL (useful for settings)
export const updateApiUrl = (newUrl: string) => {
  API_CONFIG.BASE_URL = newUrl;
};
