import React from 'react';
import { NavigationContainer } from '@react-navigation/native';
import { createStackNavigator } from '@react-navigation/stack';
import { Provider as PaperProvider } from 'react-native-paper';

import { RootStackParamList } from '../types';
import MainScreen from '../screens/MainScreen';
import ChatScreen from '../screens/ChatScreen';
import ProfileScreen from '../screens/ProfileScreen';
import DiscoverScreen from '../screens/DiscoverScreen';
import DeepDiveScreen from '../screens/DeepDiveScreen';

const Stack = createStackNavigator<RootStackParamList>();

// Main App Navigator
export default function AppNavigator() {
  return (
    <PaperProvider>
      <NavigationContainer>
        <Stack.Navigator
          screenOptions={{
            headerShown: false, // Hide headers for clean design
          }}
        >
          <Stack.Screen 
            name="Main" 
            component={MainScreen} 
          />
          <Stack.Screen 
            name="Profile" 
            component={ProfileScreen} 
          />
          <Stack.Screen 
            name="Discover" 
            component={DiscoverScreen} 
          />
          <Stack.Screen 
            name="DeepDive" 
            component={DeepDiveScreen} 
          />
        </Stack.Navigator>
      </NavigationContainer>
    </PaperProvider>
  );
}
