# OneSignal Push Notifications Setup

## Overview
This application now includes a comprehensive OneSignal push notification system that allows you to send dynamic, topic-based notifications to users based on their interests and preferences.

## Features

### 🎯 **Dynamic Targeting**
- **Categories**: Politics, Business, Sports, Technology, Entertainment, Health, Science, World, Local
- **Locations**: Ghana, Accra, Akwatia, Kumasi, Tema, Tamale, Cape Coast, Sekondi-Takoradi
- **Interests**: Technology, Entertainment, Sports, Politics, Business, Health, Science, Travel, Food, Fashion
- **Audience**: All Users, Registered Users Only, Premium Users Only

### 📱 **Notification Types**
- **Breaking News**: Instant alerts for urgent news
- **Daily Digest**: Daily summary of top stories
- **Weekly Summary**: Weekly roundup of important news
- **Marketing**: Promotional content and updates

### ⚙️ **User Preferences**
- **Quiet Hours**: Set specific times when users don't want notifications
- **Preferred Days**: Choose which days to receive notifications
- **Preferred Times**: Set specific times for notifications
- **Category Selection**: Users can choose which news categories they want
- **Location Selection**: Users can select their preferred locations

### 📊 **Admin Management**
- **Campaign Creation**: Create and manage notification campaigns
- **Analytics**: Track delivery rates, click rates, and conversions
- **Subscription Management**: View and manage user subscriptions
- **Scheduling**: Schedule notifications for specific times
- **Immediate Sending**: Send notifications instantly

## Setup Instructions

### 1. OneSignal Account Setup
1. Go to [OneSignal.com](https://onesignal.com) and create an account
2. Create a new app for your website
3. Get your App ID and REST API Key from the OneSignal dashboard

### 2. Environment Configuration
Add the following to your `.env` file:

```env
# OneSignal Configuration
ONESIGNAL_APP_ID=your_app_id_here
ONESIGNAL_REST_API_KEY=your_rest_api_key_here
ONESIGNAL_USER_AUTH_KEY=your_user_auth_key_here
ONESIGNAL_SAFARI_WEB_ID=your_safari_web_id_here
```

### 3. Database Setup
The required database tables have already been created:
- `notification_campaigns` - Stores notification campaigns
- `user_notification_subscriptions` - Stores user subscription preferences
- `notification_logs` - Tracks notification delivery and engagement

### 4. Service Worker
The OneSignal service worker (`OneSignalSDKWorker.js`) has been added to the root directory and is automatically loaded.

## Usage

### Admin Panel
1. Go to **Admin Panel > Notifications**
2. Click **"Create Campaign"** to create a new notification
3. Set targeting options (categories, locations, interests, audience)
4. Schedule the notification or send immediately
5. View analytics and performance metrics

### User Preferences
1. Users can access notification preferences in their dashboard
2. They can choose notification types, categories, and locations
3. Set quiet hours and preferred notification times
4. Preferences are automatically synced with OneSignal

### API Endpoints
- `POST /api/onesignal/subscribe` - Subscribe user to notifications
- `POST /api/onesignal/preferences` - Update notification preferences
- `POST /api/onesignal/unsubscribe` - Unsubscribe from notifications
- `GET /api/onesignal/preferences` - Get current preferences

### Console Commands
- `php artisan notifications:daily-digest` - Send daily digest notifications
- `php artisan notifications:breaking-news "Title" "Message" --url="https://example.com"` - Send breaking news

## File Structure

```
app/
├── Console/Commands/
│   ├── SendDailyDigest.php
│   └── SendBreakingNews.php
├── Http/Controllers/
│   ├── Admin/NotificationController.php
│   └── Api/OneSignalController.php
├── Models/
│   ├── NotificationCampaign.php
│   ├── UserNotificationSubscription.php
│   └── NotificationLog.php
└── Services/
    └── OneSignalService.php

resources/views/
├── admin/notifications/
│   ├── index.blade.php
│   ├── create.blade.php
│   ├── analytics.blade.php
│   └── subscriptions.blade.php
└── user/preferences.blade.php (updated with notification settings)

database/migrations/
├── create_notification_campaigns_table.php
├── create_user_notification_subscriptions_table.php
└── create_notification_logs_table.php
```

## Features in Detail

### Campaign Management
- **Draft Mode**: Create campaigns without sending
- **Scheduling**: Set specific send times
- **Immediate Sending**: Send campaigns instantly
- **Rich Content**: Support for images, icons, and action buttons
- **Targeting**: Precise audience targeting based on user preferences

### Analytics & Tracking
- **Delivery Rates**: Track successful notification deliveries
- **Click Rates**: Monitor user engagement
- **Conversion Tracking**: Track user actions after clicking
- **Performance Metrics**: Compare campaign performance

### User Experience
- **Automatic Subscription**: Users are automatically subscribed when they visit
- **Preference Management**: Easy-to-use preference interface
- **Quiet Hours**: Respect user's preferred notification times
- **Category Filtering**: Users only receive relevant notifications

## Best Practices

### Content Guidelines
- Keep titles under 255 characters
- Keep messages under 500 characters
- Use clear, actionable language
- Include relevant images when possible

### Timing
- Respect quiet hours set by users
- Send breaking news immediately
- Schedule daily digests for morning hours
- Avoid sending too many notifications per day

### Targeting
- Use specific categories and locations for better engagement
- Test campaigns with small audiences first
- Monitor analytics to optimize targeting

## Troubleshooting

### Common Issues
1. **Notifications not sending**: Check OneSignal API keys in `.env`
2. **Users not receiving notifications**: Verify browser notification permissions
3. **Analytics not updating**: Check OneSignal webhook configuration

### Debug Mode
Enable debug logging by adding to `.env`:
```env
LOG_LEVEL=debug
```

## Support
For technical support or questions about the OneSignal integration, refer to:
- [OneSignal Documentation](https://documentation.onesignal.com/)
- [OneSignal Web SDK](https://documentation.onesignal.com/docs/web-push-sdk)
- [OneSignal REST API](https://documentation.onesignal.com/reference)

---

**Status**: ✅ Ready for Production
**Last Updated**: September 6, 2025


## Overview
This application now includes a comprehensive OneSignal push notification system that allows you to send dynamic, topic-based notifications to users based on their interests and preferences.

## Features

### 🎯 **Dynamic Targeting**
- **Categories**: Politics, Business, Sports, Technology, Entertainment, Health, Science, World, Local
- **Locations**: Ghana, Accra, Akwatia, Kumasi, Tema, Tamale, Cape Coast, Sekondi-Takoradi
- **Interests**: Technology, Entertainment, Sports, Politics, Business, Health, Science, Travel, Food, Fashion
- **Audience**: All Users, Registered Users Only, Premium Users Only

### 📱 **Notification Types**
- **Breaking News**: Instant alerts for urgent news
- **Daily Digest**: Daily summary of top stories
- **Weekly Summary**: Weekly roundup of important news
- **Marketing**: Promotional content and updates

### ⚙️ **User Preferences**
- **Quiet Hours**: Set specific times when users don't want notifications
- **Preferred Days**: Choose which days to receive notifications
- **Preferred Times**: Set specific times for notifications
- **Category Selection**: Users can choose which news categories they want
- **Location Selection**: Users can select their preferred locations

### 📊 **Admin Management**
- **Campaign Creation**: Create and manage notification campaigns
- **Analytics**: Track delivery rates, click rates, and conversions
- **Subscription Management**: View and manage user subscriptions
- **Scheduling**: Schedule notifications for specific times
- **Immediate Sending**: Send notifications instantly

## Setup Instructions

### 1. OneSignal Account Setup
1. Go to [OneSignal.com](https://onesignal.com) and create an account
2. Create a new app for your website
3. Get your App ID and REST API Key from the OneSignal dashboard

### 2. Environment Configuration
Add the following to your `.env` file:

```env
# OneSignal Configuration
ONESIGNAL_APP_ID=your_app_id_here
ONESIGNAL_REST_API_KEY=your_rest_api_key_here
ONESIGNAL_USER_AUTH_KEY=your_user_auth_key_here
ONESIGNAL_SAFARI_WEB_ID=your_safari_web_id_here
```

### 3. Database Setup
The required database tables have already been created:
- `notification_campaigns` - Stores notification campaigns
- `user_notification_subscriptions` - Stores user subscription preferences
- `notification_logs` - Tracks notification delivery and engagement

### 4. Service Worker
The OneSignal service worker (`OneSignalSDKWorker.js`) has been added to the root directory and is automatically loaded.

## Usage

### Admin Panel
1. Go to **Admin Panel > Notifications**
2. Click **"Create Campaign"** to create a new notification
3. Set targeting options (categories, locations, interests, audience)
4. Schedule the notification or send immediately
5. View analytics and performance metrics

### User Preferences
1. Users can access notification preferences in their dashboard
2. They can choose notification types, categories, and locations
3. Set quiet hours and preferred notification times
4. Preferences are automatically synced with OneSignal

### API Endpoints
- `POST /api/onesignal/subscribe` - Subscribe user to notifications
- `POST /api/onesignal/preferences` - Update notification preferences
- `POST /api/onesignal/unsubscribe` - Unsubscribe from notifications
- `GET /api/onesignal/preferences` - Get current preferences

### Console Commands
- `php artisan notifications:daily-digest` - Send daily digest notifications
- `php artisan notifications:breaking-news "Title" "Message" --url="https://example.com"` - Send breaking news

## File Structure

```
app/
├── Console/Commands/
│   ├── SendDailyDigest.php
│   └── SendBreakingNews.php
├── Http/Controllers/
│   ├── Admin/NotificationController.php
│   └── Api/OneSignalController.php
├── Models/
│   ├── NotificationCampaign.php
│   ├── UserNotificationSubscription.php
│   └── NotificationLog.php
└── Services/
    └── OneSignalService.php

resources/views/
├── admin/notifications/
│   ├── index.blade.php
│   ├── create.blade.php
│   ├── analytics.blade.php
│   └── subscriptions.blade.php
└── user/preferences.blade.php (updated with notification settings)

database/migrations/
├── create_notification_campaigns_table.php
├── create_user_notification_subscriptions_table.php
└── create_notification_logs_table.php
```

## Features in Detail

### Campaign Management
- **Draft Mode**: Create campaigns without sending
- **Scheduling**: Set specific send times
- **Immediate Sending**: Send campaigns instantly
- **Rich Content**: Support for images, icons, and action buttons
- **Targeting**: Precise audience targeting based on user preferences

### Analytics & Tracking
- **Delivery Rates**: Track successful notification deliveries
- **Click Rates**: Monitor user engagement
- **Conversion Tracking**: Track user actions after clicking
- **Performance Metrics**: Compare campaign performance

### User Experience
- **Automatic Subscription**: Users are automatically subscribed when they visit
- **Preference Management**: Easy-to-use preference interface
- **Quiet Hours**: Respect user's preferred notification times
- **Category Filtering**: Users only receive relevant notifications

## Best Practices

### Content Guidelines
- Keep titles under 255 characters
- Keep messages under 500 characters
- Use clear, actionable language
- Include relevant images when possible

### Timing
- Respect quiet hours set by users
- Send breaking news immediately
- Schedule daily digests for morning hours
- Avoid sending too many notifications per day

### Targeting
- Use specific categories and locations for better engagement
- Test campaigns with small audiences first
- Monitor analytics to optimize targeting

## Troubleshooting

### Common Issues
1. **Notifications not sending**: Check OneSignal API keys in `.env`
2. **Users not receiving notifications**: Verify browser notification permissions
3. **Analytics not updating**: Check OneSignal webhook configuration

### Debug Mode
Enable debug logging by adding to `.env`:
```env
LOG_LEVEL=debug
```

## Support
For technical support or questions about the OneSignal integration, refer to:
- [OneSignal Documentation](https://documentation.onesignal.com/)
- [OneSignal Web SDK](https://documentation.onesignal.com/docs/web-push-sdk)
- [OneSignal REST API](https://documentation.onesignal.com/reference)

---

**Status**: ✅ Ready for Production
**Last Updated**: September 6, 2025
