# Mews - AI-Powered News Chatbot

<p align="center">
  <img src="public/assets/images/team/mews_logo-removebg-preview.png" width="200" alt="Mews Logo">
</p>

<p align="center">
  <strong>An intelligent news chatbot application built with Laravel 11 and OpenAI GPT-4 Turbo</strong>
</p>

<p align="center">
  <a href="#features">Features</a> •
  <a href="#requirements">Requirements</a> •
  <a href="#installation">Installation</a> •
  <a href="#configuration">Configuration</a> •
  <a href="#usage">Usage</a> •
  <a href="#api-keys">API Keys</a> •
  <a href="#deployment">Deployment</a>
</p>

---

## 🚀 Features

- **AI-Powered Chatbot**: Intelligent news analysis using OpenAI GPT-4 Turbo
- **Real-time News**: Live news fetching and processing
- **Deep Dive Articles**: Detailed article analysis with AI-powered Q&A
- **User Management**: Registration, profiles, and preferences
- **Push Notifications**: OneSignal integration for breaking news alerts
- **Admin Dashboard**: Complete admin panel for content and user management
- **Responsive Design**: Mobile-first design with light/dark themes
- **PWA Support**: Progressive Web App capabilities
- **Content Cleaning**: Advanced content processing and media handling

## 📋 Requirements

- **PHP**: 8.2 or higher
- **Composer**: Latest version
- **MySQL**: 5.7 or higher
- **Web Server**: Apache/Nginx (XAMPP recommended for development)
- **Node.js**: 16+ (for asset compilation)
- **Extensions**: BCMath, Ctype, cURL, DOM, Fileinfo, JSON, Mbstring, OpenSSL, PCRE, PDO, Tokenizer, XML

## 🛠️ Installation

### 1. Clone the Repository

```bash
git clone https://github.com/justicear9/Mews.git
cd Mews
```

### 2. Install Dependencies

```bash
composer install
npm install
```

### 3. Environment Setup

The `.env` file is included in this private repository with all necessary configuration. If you need to modify settings:

```bash
cp .env.example .env
php artisan key:generate
```

### 4. Database Setup

Create a MySQL database and update the `.env` file with your database credentials:

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=mews
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

Run migrations:

```bash
php artisan migrate
php artisan db:seed
```

### 5. Storage Setup

```bash
php artisan storage:link
```

### 6. Compile Assets

```bash
npm run build
```

## ⚙️ Configuration

### Required API Keys

Update your `.env` file with the following API keys:

#### OpenAI Configuration
```env
OPENAI_API_KEY=your_openai_api_key
OPENAI_MODEL=gpt-4-turbo
```

#### OneSignal Configuration (Optional)
```env
ONESIGNAL_APP_ID=your_onesignal_app_id
ONESIGNAL_REST_API_KEY=your_onesignal_rest_api_key
```

#### Database Configuration
```env
# Main database
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=mews
DB_USERNAME=your_username
DB_PASSWORD=your_password

# Crawler database (for news data)
CRAWLER_DB_HOST=your_crawler_host
CRAWLER_DB_DATABASE=your_crawler_database
CRAWLER_DB_USERNAME=your_crawler_username
CRAWLER_DB_PASSWORD=your_crawler_password
```

### Application Settings

```env
APP_NAME="Mews"
APP_ENV=production
APP_KEY=base64:your_app_key
APP_DEBUG=false
APP_URL=http://localhost/mews/public

# Session and Cache
SESSION_DRIVER=database
CACHE_DRIVER=file
QUEUE_CONNECTION=database
```

## 🚀 Usage

### Development Server (XAMPP)

1. **Start XAMPP**: Launch Apache and MySQL services
2. **Access Application**: Navigate to `http://localhost/mews/public`
3. **Admin Panel**: Access at `http://localhost/mews/public/admin`

### Laravel Development Server

```bash
php artisan serve
```

Access at `http://localhost:8000`

## 📱 Features Overview

### Chatbot Interface
- **Smart News Analysis**: Ask questions about current events
- **Contextual Responses**: AI understands conversation context
- **Media Support**: Images and videos in responses
- **Query Logging**: Track user interactions

### Deep Dive Articles
- **Full Article View**: Complete news articles with media
- **AI Q&A**: Ask specific questions about articles
- **Content Cleaning**: Removes ads and unwanted content
- **Video Integration**: Play video buttons for embedded content

### User Management
- **User Registration**: Create accounts with profiles
- **Reading History**: Track articles read
- **Bookmarks**: Save favorite articles
- **Preferences**: Customize news categories and settings

### Admin Dashboard
- **User Management**: View and manage users
- **Content Management**: Control news sources and settings
- **Analytics**: Track usage and engagement
- **Notification Campaigns**: Send push notifications

## 🔧 API Integration

### OpenAI Integration
The application uses OpenAI's GPT-4 Turbo for:
- News analysis and summarization
- User query processing
- Article Q&A functionality
- Content generation

### OneSignal Integration
Push notification service for:
- Breaking news alerts
- Daily news digests
- User engagement campaigns

## 📁 Project Structure

```
Mews/
├── app/
│   ├── Http/Controllers/     # Application controllers
│   ├── Models/              # Eloquent models
│   ├── Services/            # Business logic services
│   └── Console/Commands/    # Artisan commands
├── database/
│   ├── migrations/          # Database schema
│   └── seeders/            # Database seeders
├── public/
│   ├── assets/             # CSS, JS, images
│   └── index.php           # Application entry point
├── resources/
│   ├── views/              # Blade templates
│   ├── css/                # SCSS files
│   └── js/                 # JavaScript files
├── routes/
│   └── web.php             # Web routes
└── storage/                # File storage
```

## 🚀 Deployment

### Production Checklist

1. **Environment Setup**
   - Set `APP_ENV=production`
   - Set `APP_DEBUG=false`
   - Configure production database
   - Set secure `APP_KEY`

2. **Server Requirements**
   - PHP 8.2+ with required extensions
   - MySQL 5.7+
   - Web server (Apache/Nginx)
   - SSL certificate (recommended)

3. **Optimization**
   ```bash
   composer install --optimize-autoloader --no-dev
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   ```

4. **Permissions**
   ```bash
   chmod -R 755 storage bootstrap/cache
   chown -R www-data:www-data storage bootstrap/cache
   ```

### XAMPP Deployment

1. Copy project to `htdocs` folder
2. Start Apache and MySQL
3. Access via `http://localhost/mews/public`
4. Configure virtual host for custom domain

## 🔒 Security

- **Environment Variables**: Sensitive data in `.env` file
- **CSRF Protection**: Laravel's built-in CSRF tokens
- **SQL Injection**: Eloquent ORM protection
- **XSS Protection**: Blade templating escaping
- **Authentication**: Secure user authentication system

## 📊 Database Schema

### Key Tables
- `users` - User accounts and authentication
- `user_profiles` - Extended user information
- `user_preferences` - User settings and preferences
- `reading_history` - Article reading tracking
- `user_bookmarks` - Saved articles
- `query_logs` - AI interaction logs
- `notification_campaigns` - Push notification campaigns

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## 📄 License

This project is private and proprietary. All rights reserved.

## 🆘 Support

For support and questions:
- Create an issue in the repository
- Contact the development team

## 🔄 Changelog

### Version 1.0.0
- Initial release
- AI-powered news chatbot
- User management system
- Admin dashboard
- Push notification integration
- PWA support
- Responsive design

---

<p align="center">
  <strong>Built with ❤️ using Laravel 11 and OpenAI GPT-4 Turbo</strong>
</p>