<?php

namespace App\Console\Commands;

use App\Services\OneSignalService;
use Illuminate\Console\Command;

class SendDailyDigest extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notifications:daily-digest';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send daily digest notifications to subscribed users';

    /**
     * Execute the console command.
     */
    public function handle(OneSignalService $oneSignalService)
    {
        $this->info('Starting daily digest notification process...');

        try {
            $result = $oneSignalService->sendDailyDigest();

            if ($result) {
                $this->info('Daily digest notifications sent successfully!');
                return Command::SUCCESS;
            } else {
                $this->error('Failed to send daily digest notifications.');
                return Command::FAILURE;
            }
        } catch (\Exception $e) {
            $this->error('Error sending daily digest: ' . $e->getMessage());
            return Command::FAILURE;
        }
    }
}