<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class LoginController extends Controller
{
    /**
     * Show the login form.
     */
    public function showLoginForm()
    {
        // Regenerate CSRF token to prevent 419 errors after logout
        request()->session()->regenerateToken();
        
        return view('auth.login');
    }

    /**
     * Handle user login.
     */
    public function login(Request $request)
    {
        $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required'],
        ]);

        $credentials = $request->only('email', 'password');
        $remember = $request->boolean('remember');

        if (Auth::attempt($credentials, $remember)) {
            $request->session()->regenerate();

            // Update last active timestamp
            if (Auth::user()->profile) {
                Auth::user()->profile->updateLastActive();
            }

            return redirect()->intended(route('news.chatbot'))
                ->with('success', 'Welcome back, ' . Auth::user()->display_name . '!')
                ->with('pwa_restart', true);
        }

        return back()->withErrors([
            'email' => 'The provided credentials do not match our records.',
        ])->onlyInput('email');
    }

    /**
     * Handle user logout.
     */
    public function logout(Request $request)
    {
        Auth::logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();
        
        // Clear all session data
        $request->session()->flush();
        
        // Regenerate session ID
        $request->session()->regenerate();

        return redirect()->route('news.chatbot')
            ->with('success', 'You have been logged out successfully.');
    }
}