<?php

namespace App\Models\Election;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Constituency extends Model
{
    protected $fillable = [
        'region_id',
        'name',
        'code',
        'registered_voters',
    ];

    protected $casts = [
        'registered_voters' => 'integer',
    ];

    public function region(): BelongsTo
    {
        return $this->belongsTo(Region::class);
    }

    public function electionResults(): HasMany
    {
        return $this->hasMany(ElectionResultConstituency::class);
    }

    public function electionCandidates(): HasMany
    {
        return $this->hasMany(ElectionCandidate::class);
    }
}
