<?php

namespace App\Models\Election;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ElectionScrapedData extends Model
{
    protected $table = 'election_scraped_data';

    protected $fillable = ['election_id', 'data_type', 'payload', 'source_url', 'scraped_at'];

    protected $casts = [
        'payload' => 'array',
        'scraped_at' => 'datetime',
    ];

    public function election(): BelongsTo
    {
        return $this->belongsTo(Election::class);
    }
}
