<?php

namespace App\Models\Election;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Party extends Model
{
    protected $fillable = [
        'name',
        'short_name',
        'color',
        'logo_url',
        'description',
        'founded_year',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'founded_year' => 'integer',
    ];

    public function candidates(): HasMany
    {
        return $this->hasMany(Candidate::class);
    }

    public function electionResults(): HasMany
    {
        return $this->hasMany(ElectionResultRegional::class);
    }

    public function parliamentarySeats(): HasMany
    {
        return $this->hasMany(ParliamentarySeat::class);
    }

    public function polls(): HasMany
    {
        return $this->hasMany(PollResult::class);
    }

    /**
     * Get the party's color for charts (with fallback)
     */
    public function getChartColorAttribute(): string
    {
        return $this->color ?? '#808080';
    }
}
