<?php

namespace App\Models\Election;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PollResult extends Model
{
    protected $fillable = [
        'poll_id',
        'candidate_id',
        'party_id',
        'percentage',
        'lower_bound',
        'upper_bound',
    ];

    protected $casts = [
        'percentage' => 'decimal:2',
        'lower_bound' => 'decimal:2',
        'upper_bound' => 'decimal:2',
    ];

    public function poll(): BelongsTo
    {
        return $this->belongsTo(Poll::class);
    }

    public function candidate(): BelongsTo
    {
        return $this->belongsTo(Candidate::class);
    }

    public function party(): BelongsTo
    {
        return $this->belongsTo(Party::class);
    }

    /**
     * Get confidence interval as formatted string
     */
    public function getConfidenceIntervalAttribute(): ?string
    {
        if ($this->lower_bound && $this->upper_bound) {
            return "{$this->lower_bound}% - {$this->upper_bound}%";
        }
        return null;
    }
}
