<?php
require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

echo "=== AI Settings Check ===\n";

// Check if table exists
if (Schema::hasTable('ai_settings')) {
    echo "✅ ai_settings table exists\n";
    
    $count = DB::table('ai_settings')->count();
    echo "📊 Current settings count: $count\n";
    
    if ($count > 0) {
        echo "\n📋 Current settings:\n";
        $settings = DB::table('ai_settings')->get();
        foreach ($settings as $setting) {
            echo "  - {$setting->setting_key}: {$setting->setting_value} (category: {$setting->category})\n";
        }
    } else {
        echo "⚠️  No settings found in database\n";
    }
} else {
    echo "❌ ai_settings table does not exist\n";
}

echo "\n=== End Check ===\n";
