<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_preferences', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('theme')->default('light'); // light, dark, auto
            $table->string('font_size')->default('medium'); // small, medium, large
            $table->boolean('auto_play_videos')->default(false);
            $table->boolean('show_images')->default(true);
            $table->string('news_display_mode')->default('cards'); // cards, list, compact
            $table->integer('articles_per_page')->default(10);
            $table->json('category_preferences')->nullable(); // Preferred news categories
            $table->json('blocked_sources')->nullable(); // Sources user wants to block
            $table->json('blocked_keywords')->nullable(); // Keywords to filter out
            $table->boolean('ai_suggestions')->default(true);
            $table->boolean('trending_alerts')->default(true);
            $table->string('timezone')->default('Africa/Accra');
            $table->timestamps();
            
            $table->unique('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_preferences');
    }
};