<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reading_history', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('article_id'); // ID from vw_crawler_mews
            $table->string('article_title');
            $table->string('article_category')->nullable();
            $table->string('article_source')->nullable();
            $table->string('access_method')->default('chatbot'); // chatbot, direct, search, recommendation
            $table->integer('reading_time_seconds')->nullable(); // Time spent reading
            $table->boolean('completed')->default(false); // Did they finish reading?
            $table->integer('scroll_percentage')->nullable(); // How much of article they scrolled
            $table->timestamp('read_at');
            $table->timestamps();
            
            $table->index(['user_id', 'read_at']);
            $table->index(['article_id', 'read_at']);
            $table->index(['user_id', 'article_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reading_history');
    }
};