<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notification_campaigns', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('message');
            $table->string('icon')->nullable();
            $table->string('image_url')->nullable();
            $table->string('action_url')->nullable();
            $table->string('action_text')->nullable();
            
            // Targeting
            $table->json('target_categories')->nullable(); // ['politics', 'business', 'sports']
            $table->json('target_locations')->nullable(); // ['ghana', 'accra', 'akwatia']
            $table->json('target_interests')->nullable(); // ['technology', 'entertainment']
            $table->string('target_audience')->default('all'); // 'all', 'registered', 'premium'
            
            // Scheduling
            $table->timestamp('scheduled_at')->nullable();
            $table->timestamp('expires_at')->nullable();
            $table->boolean('is_immediate')->default(false);
            
            // Status
            $table->enum('status', ['draft', 'scheduled', 'sent', 'cancelled'])->default('draft');
            $table->boolean('is_active')->default(true);
            
            // Analytics
            $table->integer('sent_count')->default(0);
            $table->integer('delivered_count')->default(0);
            $table->integer('clicked_count')->default(0);
            $table->integer('converted_count')->default(0);
            
            // OneSignal specific
            $table->string('onesignal_segment')->nullable();
            $table->string('onesignal_campaign_id')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notification_campaigns');
    }
};