<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_notification_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade');
            $table->string('onesignal_player_id')->unique();
            $table->string('device_type')->nullable(); // 'web', 'android', 'ios'
            $table->string('browser')->nullable();
            $table->string('os')->nullable();
            $table->string('country')->nullable();
            $table->string('timezone')->nullable();
            
            // Subscription preferences
            $table->json('subscribed_categories')->nullable(); // ['politics', 'business']
            $table->json('subscribed_locations')->nullable(); // ['ghana', 'accra']
            $table->json('subscribed_interests')->nullable(); // ['technology', 'sports']
            $table->boolean('breaking_news_enabled')->default(true);
            $table->boolean('daily_digest_enabled')->default(true);
            $table->boolean('weekly_summary_enabled')->default(true);
            $table->boolean('marketing_enabled')->default(false);
            
            // Timing preferences
            $table->time('quiet_hours_start')->nullable(); // 22:00
            $table->time('quiet_hours_end')->nullable(); // 08:00
            $table->json('preferred_days')->nullable(); // ['monday', 'tuesday', 'wednesday']
            $table->json('preferred_times')->nullable(); // ['09:00', '12:00', '18:00']
            
            // Status
            $table->boolean('is_active')->default(true);
            $table->timestamp('last_activity_at')->nullable();
            $table->timestamp('subscribed_at')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index(['user_id', 'is_active']);
            $table->index('onesignal_player_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_notification_subscriptions');
    }
};