<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notification_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('campaign_id')->constrained('notification_campaigns')->onDelete('cascade');
            $table->foreignId('subscription_id')->nullable()->constrained('user_notification_subscriptions')->onDelete('set null');
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            $table->string('onesignal_player_id');
            $table->string('onesignal_notification_id')->nullable();
            
            // Delivery status
            $table->enum('status', ['sent', 'delivered', 'clicked', 'converted', 'failed'])->default('sent');
            $table->timestamp('sent_at');
            $table->timestamp('delivered_at')->nullable();
            $table->timestamp('clicked_at')->nullable();
            $table->timestamp('converted_at')->nullable();
            
            // Error tracking
            $table->text('error_message')->nullable();
            $table->string('error_code')->nullable();
            
            // Analytics
            $table->json('metadata')->nullable(); // Additional tracking data
            $table->string('utm_source')->nullable();
            $table->string('utm_medium')->nullable();
            $table->string('utm_campaign')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index(['campaign_id', 'status']);
            $table->index(['user_id', 'status']);
            $table->index('onesignal_notification_id');
            $table->index('sent_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notification_logs');
    }
};