<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add web search toggle setting to ai_settings table
        DB::table('ai_settings')->insert([
            'setting_key' => 'ai_web_search_enabled',
            'setting_value' => 'true',
            'setting_type' => 'boolean',
            'description' => 'Enable web search capabilities for real-time information (requires search-enabled model)',
            'category' => 'ai',
            'is_editable' => true,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::table('ai_settings')->where('setting_key', 'ai_web_search_enabled')->delete();
    }
};