<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('election_scraped_data', function (Blueprint $table) {
            $table->id();
            $table->foreignId('election_id')->constrained('elections')->onDelete('cascade');
            $table->string('data_type', 64); // national_summary, regional_votes, swing_constituencies, marginal_wins, regional_analysis
            $table->json('payload');
            $table->string('source_url', 512)->nullable();
            $table->timestamp('scraped_at');
            $table->timestamps();

            $table->unique(['election_id', 'data_type'], 'election_scraped_type_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('election_scraped_data');
    }
};
