<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Add Brong Ahafo region for 2000/2010 census data (10 regions existed then).
     */
    public function up(): void
    {
        $exists = DB::table('regions')->where('code', 'BA')->orWhere('name', 'Brong Ahafo')->exists();
        if (! $exists) {
            DB::table('regions')->insert([
                'name' => 'Brong Ahafo',
                'code' => 'BA',
                'population' => null,
                'registered_voters' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }

    public function down(): void
    {
        DB::table('regions')->where('code', 'BA')->delete();
    }
};
