var $64fc3370e682155f$exports = require("./utils.main.js");
var $6d1SX$reactariautils = require("@react-aria/utils");
var $6d1SX$reactarialabel = require("@react-aria/label");
var $6d1SX$reactariainteractions = require("@react-aria/interactions");


function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {get: v, set: s, enumerable: true, configurable: true});
}

$parcel$export(module.exports, "useCheckboxGroup", () => $253685172d17db7d$export$49ff6f28c54f1cbe);
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 



function $253685172d17db7d$export$49ff6f28c54f1cbe(props, state) {
    let { isDisabled: isDisabled, name: name, form: form, validationBehavior: validationBehavior = 'aria' } = props;
    let { isInvalid: isInvalid, validationErrors: validationErrors, validationDetails: validationDetails } = state.displayValidation;
    let { labelProps: labelProps, fieldProps: fieldProps, descriptionProps: descriptionProps, errorMessageProps: errorMessageProps } = (0, $6d1SX$reactarialabel.useField)({
        ...props,
        // Checkbox group is not an HTML input element so it
        // shouldn't be labeled by a <label> element.
        labelElementType: 'span',
        isInvalid: isInvalid,
        errorMessage: props.errorMessage || validationErrors
    });
    (0, $64fc3370e682155f$exports.checkboxGroupData).set(state, {
        name: name,
        form: form,
        descriptionId: descriptionProps.id,
        errorMessageId: errorMessageProps.id,
        validationBehavior: validationBehavior
    });
    let domProps = (0, $6d1SX$reactariautils.filterDOMProps)(props, {
        labelable: true
    });
    let { focusWithinProps: focusWithinProps } = (0, $6d1SX$reactariainteractions.useFocusWithin)({
        onBlurWithin: props.onBlur,
        onFocusWithin: props.onFocus,
        onFocusWithinChange: props.onFocusChange
    });
    return {
        groupProps: (0, $6d1SX$reactariautils.mergeProps)(domProps, {
            role: 'group',
            'aria-disabled': isDisabled || undefined,
            ...fieldProps,
            ...focusWithinProps
        }),
        labelProps: labelProps,
        descriptionProps: descriptionProps,
        errorMessageProps: errorMessageProps,
        isInvalid: isInvalid,
        validationErrors: validationErrors,
        validationDetails: validationDetails
    };
}


//# sourceMappingURL=useCheckboxGroup.main.js.map
