import $4lVjK$intlStringsmodulejs from "./intlStrings.module.js";
import {roleSymbol as $16f0b7bb276bc17e$export$300019f83c56d282} from "./useDateField.module.js";
import {useDatePickerGroup as $3dfb0f96be0d6a08$export$4a931266a3838b86} from "./useDatePickerGroup.module.js";
import {createFocusManager as $4lVjK$createFocusManager} from "@react-aria/focus";
import {useId as $4lVjK$useId, useDescription as $4lVjK$useDescription, filterDOMProps as $4lVjK$filterDOMProps, mergeProps as $4lVjK$mergeProps} from "@react-aria/utils";
import {privateValidationStateProp as $4lVjK$privateValidationStateProp} from "@react-stately/form";
import {useField as $4lVjK$useField} from "@react-aria/label";
import {useFocusWithin as $4lVjK$useFocusWithin} from "@react-aria/interactions";
import {useLocalizedStringFormatter as $4lVjK$useLocalizedStringFormatter, useLocale as $4lVjK$useLocale} from "@react-aria/i18n";
import {useMemo as $4lVjK$useMemo, useRef as $4lVjK$useRef} from "react";


function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 









function $6057a3d2a53a12fd$export$42df105a73306d51(props, state, ref) {
    let buttonId = (0, $4lVjK$useId)();
    let dialogId = (0, $4lVjK$useId)();
    let fieldId = (0, $4lVjK$useId)();
    let stringFormatter = (0, $4lVjK$useLocalizedStringFormatter)((0, ($parcel$interopDefault($4lVjK$intlStringsmodulejs))), '@react-aria/datepicker');
    let { isInvalid: isInvalid, validationErrors: validationErrors, validationDetails: validationDetails } = state.displayValidation;
    let { labelProps: labelProps, fieldProps: fieldProps, descriptionProps: descriptionProps, errorMessageProps: errorMessageProps } = (0, $4lVjK$useField)({
        ...props,
        labelElementType: 'span',
        isInvalid: isInvalid,
        errorMessage: props.errorMessage || validationErrors
    });
    let groupProps = (0, $3dfb0f96be0d6a08$export$4a931266a3838b86)(state, ref);
    let labelledBy = fieldProps['aria-labelledby'] || fieldProps.id;
    let { locale: locale } = (0, $4lVjK$useLocale)();
    let date = state.formatValue(locale, {
        month: 'long'
    });
    let description = date ? stringFormatter.format('selectedDateDescription', {
        date: date
    }) : '';
    let descProps = (0, $4lVjK$useDescription)(description);
    let ariaDescribedBy = [
        descProps['aria-describedby'],
        fieldProps['aria-describedby']
    ].filter(Boolean).join(' ') || undefined;
    let domProps = (0, $4lVjK$filterDOMProps)(props);
    let focusManager = (0, $4lVjK$useMemo)(()=>(0, $4lVjK$createFocusManager)(ref), [
        ref
    ]);
    let isFocused = (0, $4lVjK$useRef)(false);
    let { focusWithinProps: focusWithinProps } = (0, $4lVjK$useFocusWithin)({
        ...props,
        isDisabled: state.isOpen,
        onBlurWithin: (e)=>{
            // Ignore when focus moves into the popover.
            let dialog = document.getElementById(dialogId);
            if (!(dialog === null || dialog === void 0 ? void 0 : dialog.contains(e.relatedTarget))) {
                var _props_onBlur, _props_onFocusChange;
                isFocused.current = false;
                (_props_onBlur = props.onBlur) === null || _props_onBlur === void 0 ? void 0 : _props_onBlur.call(props, e);
                (_props_onFocusChange = props.onFocusChange) === null || _props_onFocusChange === void 0 ? void 0 : _props_onFocusChange.call(props, false);
            }
        },
        onFocusWithin: (e)=>{
            if (!isFocused.current) {
                var _props_onFocus, _props_onFocusChange;
                isFocused.current = true;
                (_props_onFocus = props.onFocus) === null || _props_onFocus === void 0 ? void 0 : _props_onFocus.call(props, e);
                (_props_onFocusChange = props.onFocusChange) === null || _props_onFocusChange === void 0 ? void 0 : _props_onFocusChange.call(props, true);
            }
        }
    });
    return {
        groupProps: (0, $4lVjK$mergeProps)(domProps, groupProps, fieldProps, descProps, focusWithinProps, {
            role: 'group',
            'aria-disabled': props.isDisabled || null,
            'aria-labelledby': labelledBy,
            'aria-describedby': ariaDescribedBy,
            onKeyDown (e) {
                if (state.isOpen) return;
                if (props.onKeyDown) props.onKeyDown(e);
            },
            onKeyUp (e) {
                if (state.isOpen) return;
                if (props.onKeyUp) props.onKeyUp(e);
            }
        }),
        labelProps: {
            ...labelProps,
            onClick: ()=>{
                focusManager.focusFirst();
            }
        },
        fieldProps: {
            ...fieldProps,
            id: fieldId,
            [(0, $16f0b7bb276bc17e$export$300019f83c56d282)]: 'presentation',
            'aria-describedby': ariaDescribedBy,
            value: state.value,
            defaultValue: state.defaultValue,
            onChange: state.setValue,
            placeholderValue: props.placeholderValue,
            hideTimeZone: props.hideTimeZone,
            hourCycle: props.hourCycle,
            shouldForceLeadingZeros: props.shouldForceLeadingZeros,
            granularity: props.granularity,
            isDisabled: props.isDisabled,
            isReadOnly: props.isReadOnly,
            isRequired: props.isRequired,
            validationBehavior: props.validationBehavior,
            // DatePicker owns the validation state for the date field.
            [(0, $4lVjK$privateValidationStateProp)]: state,
            autoFocus: props.autoFocus,
            name: props.name,
            form: props.form
        },
        descriptionProps: descriptionProps,
        errorMessageProps: errorMessageProps,
        buttonProps: {
            ...descProps,
            id: buttonId,
            'aria-haspopup': 'dialog',
            'aria-label': stringFormatter.format('calendar'),
            'aria-labelledby': `${buttonId} ${labelledBy}`,
            'aria-describedby': ariaDescribedBy,
            'aria-expanded': state.isOpen,
            isDisabled: props.isDisabled || props.isReadOnly,
            onPress: ()=>state.setOpen(true)
        },
        dialogProps: {
            id: dialogId,
            'aria-labelledby': `${buttonId} ${labelledBy}`
        },
        calendarProps: {
            autoFocus: true,
            value: state.dateValue,
            onChange: state.setDateValue,
            minValue: props.minValue,
            maxValue: props.maxValue,
            isDisabled: props.isDisabled,
            isReadOnly: props.isReadOnly,
            isDateUnavailable: props.isDateUnavailable,
            defaultFocusedValue: state.dateValue ? undefined : props.placeholderValue,
            isInvalid: state.isInvalid,
            errorMessage: typeof props.errorMessage === 'function' ? props.errorMessage(state.displayValidation) : props.errorMessage || state.displayValidation.validationErrors.join(' '),
            firstDayOfWeek: props.firstDayOfWeek,
            pageBehavior: props.pageBehavior
        },
        isInvalid: isInvalid,
        validationErrors: validationErrors,
        validationDetails: validationDetails
    };
}


export {$6057a3d2a53a12fd$export$42df105a73306d51 as useDatePicker};
//# sourceMappingURL=useDatePicker.module.js.map
