import { CollectionStateBase, FocusStrategy, Key, Node } from "@react-types/shared";
import { FormValidationState } from "@react-stately/form";
import { ListState } from "@react-stately/list";
import { OverlayTriggerState } from "@react-stately/overlays";
import { SelectionMode, SelectProps, ValueType } from "@react-types/select";
export interface SelectStateOptions<T, M extends SelectionMode = 'single'> extends Omit<SelectProps<T, M>, 'children'>, CollectionStateBase<T> {
}
export interface SelectState<T, M extends SelectionMode = 'single'> extends ListState<T>, OverlayTriggerState, FormValidationState {
    /**
     * The key for the first selected item.
     * @deprecated
     */
    readonly selectedKey: Key | null;
    /**
     * The default selected key.
     * @deprecated
     */
    readonly defaultSelectedKey: Key | null;
    /**
     * Sets the selected key.
     * @deprecated
     */
    setSelectedKey(key: Key | null): void;
    /** The current select value. */
    readonly value: ValueType<M>;
    /** The default select value. */
    readonly defaultValue: ValueType<M>;
    /** Sets the select value. */
    setValue(value: Key | Key[] | null): void;
    /**
     * The value of the first selected item.
     * @deprecated
     */
    readonly selectedItem: Node<T> | null;
    /** The value of the selected items. */
    readonly selectedItems: Node<T>[];
    /** Whether the select is currently focused. */
    readonly isFocused: boolean;
    /** Sets whether the select is focused. */
    setFocused(isFocused: boolean): void;
    /** Controls which item will be auto focused when the menu opens. */
    readonly focusStrategy: FocusStrategy | null;
    /** Opens the menu. */
    open(focusStrategy?: FocusStrategy | null): void;
    /** Toggles the menu. */
    toggle(focusStrategy?: FocusStrategy | null): void;
}
/**
 * Provides state management for a select component. Handles building a collection
 * of items from props, handles the open state for the popup menu, and manages
 * multiple selection state.
 */
export function useSelectState<T extends object, M extends SelectionMode = 'single'>(props: SelectStateOptions<T, M>): SelectState<T, M>;
export type { SelectProps } from '@react-types/select';

//# sourceMappingURL=types.d.ts.map
