import {useSingleSelectListState as $fgY1A$useSingleSelectListState} from "@react-stately/list";
import {useRef as $fgY1A$useRef, useEffect as $fgY1A$useEffect} from "react";

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 

function $76f919a04c5a7d14$export$4ba071daf4e486(props) {
    var _props_defaultSelectedKey, _ref;
    let state = (0, $fgY1A$useSingleSelectListState)({
        ...props,
        onSelectionChange: props.onSelectionChange ? (key)=>{
            var _props_onSelectionChange;
            if (key != null) (_props_onSelectionChange = props.onSelectionChange) === null || _props_onSelectionChange === void 0 ? void 0 : _props_onSelectionChange.call(props, key);
        } : undefined,
        suppressTextValueWarning: true,
        defaultSelectedKey: (_ref = (_props_defaultSelectedKey = props.defaultSelectedKey) !== null && _props_defaultSelectedKey !== void 0 ? _props_defaultSelectedKey : $76f919a04c5a7d14$var$findDefaultSelectedKey(props.collection, props.disabledKeys ? new Set(props.disabledKeys) : new Set())) !== null && _ref !== void 0 ? _ref : undefined
    });
    let { selectionManager: selectionManager, collection: collection, selectedKey: currentSelectedKey } = state;
    let lastSelectedKey = (0, $fgY1A$useRef)(currentSelectedKey);
    (0, $fgY1A$useEffect)(()=>{
        // Ensure a tab is always selected (in case no selected key was specified or if selected item was deleted from collection)
        let selectedKey = currentSelectedKey;
        if (props.selectedKey == null && (selectionManager.isEmpty || selectedKey == null || !collection.getItem(selectedKey))) {
            selectedKey = $76f919a04c5a7d14$var$findDefaultSelectedKey(collection, state.disabledKeys);
            if (selectedKey != null) // directly set selection because replace/toggle selection won't consider disabled keys
            selectionManager.setSelectedKeys([
                selectedKey
            ]);
        }
        // If the tablist doesn't have focus and the selected key changes or if there isn't a focused key yet, change focused key to the selected key if it exists.
        if (selectedKey != null && selectionManager.focusedKey == null || !selectionManager.isFocused && selectedKey !== lastSelectedKey.current) selectionManager.setFocusedKey(selectedKey);
        lastSelectedKey.current = selectedKey;
    });
    return {
        ...state,
        isDisabled: props.isDisabled || false
    };
}
function $76f919a04c5a7d14$var$findDefaultSelectedKey(collection, disabledKeys) {
    let selectedKey = null;
    if (collection) {
        var _collection_getItem_props, _collection_getItem, _collection_getItem_props1, _collection_getItem1;
        selectedKey = collection.getFirstKey();
        // loop over tabs until we find one that isn't disabled and select that
        while(selectedKey != null && (disabledKeys.has(selectedKey) || ((_collection_getItem = collection.getItem(selectedKey)) === null || _collection_getItem === void 0 ? void 0 : (_collection_getItem_props = _collection_getItem.props) === null || _collection_getItem_props === void 0 ? void 0 : _collection_getItem_props.isDisabled)) && selectedKey !== collection.getLastKey())selectedKey = collection.getKeyAfter(selectedKey);
        // if this check is true, then every item is disabled, it makes more sense to default to the first key than the last
        if (selectedKey != null && (disabledKeys.has(selectedKey) || ((_collection_getItem1 = collection.getItem(selectedKey)) === null || _collection_getItem1 === void 0 ? void 0 : (_collection_getItem_props1 = _collection_getItem1.props) === null || _collection_getItem_props1 === void 0 ? void 0 : _collection_getItem_props1.isDisabled)) && selectedKey === collection.getLastKey()) selectedKey = collection.getFirstKey();
    }
    return selectedKey;
}


export {$76f919a04c5a7d14$export$4ba071daf4e486 as useTabListState};
//# sourceMappingURL=useTabListState.module.js.map
