"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = activeElement;
var _ownerDocument = _interopRequireDefault(require("./ownerDocument.js"));
/**
 * Returns the actively focused element safely.
 *
 * @param doc the document to check
 */
function activeElement(doc = (0, _ownerDocument.default)()) {
  // Support: IE 9 only
  // IE9 throws an "Unspecified error" accessing document.activeElement from an <iframe>
  try {
    const active = doc.activeElement;
    // IE11 returns a seemingly empty object in some cases when accessing
    // document.activeElement from an <iframe>
    if (!active || !active.nodeName) return null;
    return active;
  } catch (e) {
    /* ie throws if no active element */
    return doc.body;
  }
}
module.exports = exports.default;