@extends('admin.layout')

@section('title', 'Branding & Visual Customization')

@section('content')
<div class="admin-header">
    <h1 class="mb-0">
        <i class="fas fa-palette"></i> Branding & Visual Customization
    </h1>
    <p class="text-muted mb-0">Customize the look and feel of your chatbot</p>
</div>

<!-- Color Scheme -->
<div class="admin-card">
    <h5 class="mb-3"><i class="fas fa-palette"></i> Color Scheme</h5>
    <form action="{{ route('admin.branding.update') }}" method="POST">
        @csrf
        @method('PUT')
        
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="primary_color" class="form-label">Primary Color</label>
                    <div class="input-group">
                        <input type="color" class="form-control form-control-color" 
                               id="primary_color" name="primary_color" 
                               value="{{ $colorSettings->where('setting_key', 'primary_color')->first()->setting_value ?? '#0a57d4' }}"
                               onchange="updateColorPreview()">
                        <input type="text" class="form-control" 
                               id="primary_color_hex" name="primary_color_hex" 
                               value="{{ $colorSettings->where('setting_key', 'primary_color')->first()->setting_value ?? '#0a57d4' }}"
                               placeholder="#0a57d4">
                    </div>
                    <div class="form-text">Main brand color used throughout the interface</div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="secondary_color" class="form-label">Secondary Color</label>
                    <div class="input-group">
                        <input type="color" class="form-control form-control-color" 
                               id="secondary_color" name="secondary_color" 
                               value="{{ $colorSettings->where('setting_key', 'secondary_color')->first()->setting_value ?? '#2d72f0' }}"
                               onchange="updateColorPreview()">
                        <input type="text" class="form-control" 
                               id="secondary_color_hex" name="secondary_color_hex" 
                               value="{{ $colorSettings->where('setting_key', 'secondary_color')->first()->setting_value ?? '#2d72f0' }}"
                               placeholder="#2d72f0">
                    </div>
                    <div class="form-text">Accent color for highlights and secondary elements</div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="accent_color" class="form-label">Accent Color</label>
                    <div class="input-group">
                        <input type="color" class="form-control form-control-color" 
                               id="accent_color" name="accent_color" 
                               value="{{ $colorSettings->where('setting_key', 'accent_color')->first()->setting_value ?? '#5a95ff' }}"
                               onchange="updateColorPreview()">
                        <input type="text" class="form-control" 
                               id="accent_color_hex" name="accent_color_hex" 
                               value="{{ $colorSettings->where('setting_key', 'accent_color')->first()->setting_value ?? '#5a95ff' }}"
                               placeholder="#5a95ff">
                    </div>
                    <div class="form-text">Color for interactive elements and highlights</div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="text_color" class="form-label">Text Color</label>
                    <div class="input-group">
                        <input type="color" class="form-control form-control-color" 
                               id="text_color" name="text_color" 
                               value="{{ $colorSettings->where('setting_key', 'text_color')->first()->setting_value ?? '#333333' }}"
                               onchange="updateColorPreview()">
                        <input type="text" class="form-control" 
                               id="text_color_hex" name="text_color_hex" 
                               value="{{ $colorSettings->where('setting_key', 'text_color')->first()->setting_value ?? '#333333' }}"
                               placeholder="#333333">
                    </div>
                    <div class="form-text">Primary text color for content</div>
                </div>
            </div>
        </div>

        <!-- Color Preview -->
        <div class="border rounded p-4 bg-light">
            <h6 class="mb-3">Color Preview</h6>
            <div class="row">
                <div class="col-md-3">
                    <div class="text-center">
                        <div id="primary_preview" class="color-preview rounded mb-2" style="width: 60px; height: 60px; margin: 0 auto;"></div>
                        <small class="text-muted">Primary</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div id="secondary_preview" class="color-preview rounded mb-2" style="width: 60px; height: 60px; margin: 0 auto;"></div>
                        <small class="text-muted">Secondary</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div id="accent_preview" class="color-preview rounded mb-2" style="width: 60px; height: 60px; margin: 0 auto;"></div>
                        <small class="text-muted">Accent</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div id="text_preview" class="color-preview rounded mb-2" style="width: 60px; height: 60px; margin: 0 auto;"></div>
                        <small class="text-muted">Text</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-3">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Save Color Scheme
            </button>
        </div>
    </form>
</div>

<!-- Images & Assets -->
<div class="admin-card">
    <h5 class="mb-3"><i class="fas fa-image"></i> Images & Assets</h5>
    
    <div class="row">
        <div class="col-md-6">
            <div class="border rounded p-4 text-center">
                <h6 class="mb-3">Chatbot Avatar</h6>
                <div id="avatar_preview" class="mb-3">
                    @if($imageSettings->where('setting_key', 'chatbot_avatar')->first() && $imageSettings->where('setting_key', 'chatbot_avatar')->first()->setting_value)
                        <img src="{{ $imageSettings->where('setting_key', 'chatbot_avatar')->first()->setting_value }}" 
                             alt="Chatbot Avatar" class="rounded-circle" style="width: 100px; height: 100px; object-fit: cover;">
                    @else
                        <div class="bg-light rounded-circle d-flex align-items-center justify-content-center" style="width: 100px; height: 100px; margin: 0 auto;">
                            <i class="fas fa-robot fa-2x text-muted"></i>
                        </div>
                    @endif
                </div>
                
                <form action="{{ route('admin.branding.upload') }}" method="POST" enctype="multipart/form-data" class="mb-3">
                    @csrf
                    <input type="hidden" name="image_type" value="chatbot_avatar">
                    <div class="mb-3">
                        <input type="file" class="form-control" name="image_file" accept="image/*" required>
                        <div class="form-text">Recommended: 200x200px, PNG/JPG format</div>
                    </div>
                    <button type="submit" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-upload"></i> Upload Avatar
                    </button>
                </form>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="border rounded p-4 text-center">
                <h6 class="mb-3">Logo</h6>
                <div id="logo_preview" class="mb-3">
                    @if($imageSettings->where('setting_key', 'logo')->first() && $imageSettings->where('setting_key', 'logo')->first()->setting_value)
                        <img src="{{ $imageSettings->where('setting_key', 'logo')->first()->setting_value }}" 
                             alt="Logo" style="max-width: 150px; max-height: 80px; object-fit: contain;">
                    @else
                        <div class="bg-light rounded d-flex align-items-center justify-content-center" style="width: 150px; height: 80px; margin: 0 auto;">
                            <i class="fas fa-image fa-2x text-muted"></i>
                        </div>
                    @endif
                </div>
                
                <form action="{{ route('admin.branding.upload') }}" method="POST" enctype="multipart/form-data" class="mb-3">
                    @csrf
                    <input type="hidden" name="image_type" value="logo">
                    <div class="mb-3">
                        <input type="file" class="form-control" name="image_file" accept="image/*" required>
                        <div class="form-text">Recommended: 300x150px, PNG format with transparency</div>
                    </div>
                    <button type="submit" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-upload"></i> Upload Logo
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Text & Content -->
<div class="admin-card">
    <h5 class="mb-3"><i class="fas fa-font"></i> Text & Content</h5>
    <form action="{{ route('admin.branding.update') }}" method="POST">
        @csrf
        @method('PUT')
        
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="chatbot_name" class="form-label">Chatbot Name</label>
                    <input type="text" class="form-control" id="chatbot_name" name="chatbot_name" 
                           value="{{ $textSettings->where('setting_key', 'chatbot_name')->first()->setting_value ?? 'Mews AI' }}">
                    <div class="form-text">The name displayed for your chatbot</div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="chatbot_tagline" class="form-label">Chatbot Tagline</label>
                    <input type="text" class="form-control" id="chatbot_tagline" name="chatbot_tagline" 
                           value="{{ $textSettings->where('setting_key', 'chatbot_tagline')->first()->setting_value ?? 'Your AI News Companion' }}">
                    <div class="form-text">Short description or slogan</div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="welcome_message" class="form-label">Welcome Message</label>
                    <textarea class="form-control" id="welcome_message" name="welcome_message" rows="3">{{ $textSettings->where('setting_key', 'welcome_message')->first()->setting_value ?? 'Hello! I\'m your AI news assistant. Ask me about the latest news, sports, politics, or any topic you\'re interested in!' }}</textarea>
                    <div class="form-text">Message shown when users first visit</div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="placeholder_text" class="form-label">Input Placeholder</label>
                    <input type="text" class="form-control" id="placeholder_text" name="placeholder_text" 
                           value="{{ $textSettings->where('setting_key', 'placeholder_text')->first()->setting_value ?? 'Ask me about the latest news...' }}">
                    <div class="form-text">Text shown in the chat input field</div>
                </div>
            </div>
        </div>

        <div class="mt-3">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Save Text Settings
            </button>
        </div>
    </form>
</div>

<!-- Layout & Spacing -->
<div class="admin-card">
    <h5 class="mb-3"><i class="fas fa-arrows-alt"></i> Layout & Spacing</h5>
    <form action="{{ route('admin.branding.update') }}" method="POST">
        @csrf
        @method('PUT')
        
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="border_radius" class="form-label">Border Radius</label>
                    <select class="form-select" id="border_radius" name="border_radius">
                        <option value="none" {{ ($uiSettings->where('setting_key', 'border_radius')->first()->setting_value ?? 'rounded') == 'none' ? 'selected' : '' }}>None (Sharp corners)</option>
                        <option value="small" {{ ($uiSettings->where('setting_key', 'border_radius')->first()->setting_value ?? 'rounded') == 'small' ? 'selected' : '' }}>Small (4px)</option>
                        <option value="rounded" {{ ($uiSettings->where('setting_key', 'border_radius')->first()->setting_value ?? 'rounded') == 'rounded' ? 'selected' : '' }}>Rounded (8px)</option>
                        <option value="large" {{ ($uiSettings->where('setting_key', 'border_radius')->first()->setting_value ?? 'rounded') == 'large' ? 'selected' : '' }}>Large (16px)</option>
                        <option value="pill" {{ ($uiSettings->where('setting_key', 'border_radius')->first()->setting_value ?? 'rounded') == 'pill' ? 'selected' : '' }}>Pill (25px)</option>
                    </select>
                    <div class="form-text">Corner rounding for cards and buttons</div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="shadow_intensity" class="form-label">Shadow Intensity</label>
                    <select class="form-select" id="shadow_intensity" name="shadow_intensity">
                        <option value="none" {{ ($uiSettings->where('setting_key', 'shadow_intensity')->first()->setting_value ?? 'medium') == 'none' ? 'selected' : '' }}>None (Flat design)</option>
                        <option value="subtle" {{ ($uiSettings->where('setting_key', 'shadow_intensity')->first()->setting_value ?? 'medium') == 'subtle' ? 'selected' : '' }}>Subtle (Light shadows)</option>
                        <option value="medium" {{ ($uiSettings->where('setting_key', 'shadow_intensity')->first()->setting_value ?? 'medium') == 'medium' ? 'selected' : '' }}>Medium (Balanced)</option>
                        <option value="strong" {{ ($uiSettings->where('setting_key', 'shadow_intensity')->first()->setting_value ?? 'medium') == 'strong' ? 'selected' : '' }}>Strong (Prominent shadows)</option>
                    </select>
                    <div class="form-text">Depth and shadow effects for elements</div>
                </div>
            </div>
        </div>

        <div class="mt-3">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Save Layout Settings
            </button>
        </div>
    </form>
</div>

<!-- Live Preview -->
<div class="admin-card">
    <h5 class="mb-3"><i class="fas fa-eye"></i> Live Preview</h5>
    <div class="border rounded p-4">
        <div class="row">
            <div class="col-md-6">
                <h6>Chatbot Interface Preview</h6>
                <div id="chatbot_preview" class="border rounded p-3" style="background: white;">
                    <div class="d-flex align-items-center mb-3">
                        <div id="preview_avatar" class="rounded-circle me-2" style="width: 40px; height: 40px; background: var(--primary-color);"></div>
                        <div>
                            <h6 class="mb-0" id="preview_name">Mews AI</h6>
                            <small class="text-muted" id="preview_tagline">Your AI News Companion</small>
                        </div>
                    </div>
                    <p id="preview_welcome" class="mb-3">Hello! I'm your AI news assistant...</p>
                    <div class="input-group">
                        <input type="text" class="form-control" id="preview_input" placeholder="Ask me about the latest news...">
                        <button class="btn" id="preview_button" style="background: var(--primary-color); color: white;">Send</button>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <h6>Color Palette</h6>
                <div class="d-flex flex-wrap gap-2">
                    <div class="color-swatch rounded" id="preview_primary" style="width: 60px; height: 40px;"></div>
                    <div class="color-swatch rounded" id="preview_secondary" style="width: 60px; height: 40px;"></div>
                    <div class="color-swatch rounded" id="preview_accent" style="width: 60px; height: 40px;"></div>
                    <div class="color-swatch rounded" id="preview_text" style="width: 60px; height: 40px;"></div>
                </div>
                <div class="mt-3">
                    <button class="btn btn-outline-primary btn-sm" onclick="updatePreview()">
                        <i class="fas fa-sync"></i> Update Preview
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function updateColorPreview() {
    const primaryColor = document.getElementById('primary_color').value;
    const secondaryColor = document.getElementById('secondary_color').value;
    const accentColor = document.getElementById('accent_color').value;
    const textColor = document.getElementById('text_color').value;

    // Update hex inputs
    document.getElementById('primary_color_hex').value = primaryColor;
    document.getElementById('secondary_color_hex').value = secondaryColor;
    document.getElementById('accent_color_hex').value = accentColor;
    document.getElementById('text_color_hex').value = textColor;

    // Update preview boxes
    document.getElementById('primary_preview').style.backgroundColor = primaryColor;
    document.getElementById('secondary_preview').style.backgroundColor = secondaryColor;
    document.getElementById('accent_preview').style.backgroundColor = accentColor;
    document.getElementById('text_preview').style.backgroundColor = textColor;
}

function updatePreview() {
    // Update preview with current form values
    const primaryColor = document.getElementById('primary_color').value;
    const secondaryColor = document.getElementById('secondary_color').value;
    const accentColor = document.getElementById('accent_color').value;
    const textColor = document.getElementById('text_color').value;
    
    // Update color swatches
    document.getElementById('preview_primary').style.backgroundColor = primaryColor;
    document.getElementById('preview_secondary').style.backgroundColor = secondaryColor;
    document.getElementById('preview_accent').style.backgroundColor = accentColor;
    document.getElementById('preview_text').style.backgroundColor = textColor;
    
    // Update preview elements
    document.getElementById('preview_avatar').style.backgroundColor = primaryColor;
    document.getElementById('preview_button').style.backgroundColor = primaryColor;
    document.getElementById('preview_name').style.color = textColor;
    document.getElementById('preview_tagline').style.color = textColor;
    document.getElementById('preview_welcome').style.color = textColor;
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    updateColorPreview();
    updatePreview();
});

// Sync color picker with hex input
document.getElementById('primary_color_hex').addEventListener('input', function() {
    document.getElementById('primary_color').value = this.value;
    updateColorPreview();
});

document.getElementById('secondary_color_hex').addEventListener('input', function() {
    document.getElementById('secondary_color').value = this.value;
    updateColorPreview();
});

document.getElementById('accent_color_hex').addEventListener('input', function() {
    document.getElementById('accent_color').value = this.value;
    updateColorPreview();
});

document.getElementById('text_color_hex').addEventListener('input', function() {
    document.getElementById('text_color').value = this.value;
    updateColorPreview();
});
</script>
@endsection

