@extends('admin.layout')

@section('title', 'Create Notification Campaign')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Create Notification Campaign</h1>
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Campaigns
                </a>
            </div>

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <form action="{{ route('admin.notifications.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Campaign Details</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}" required maxlength="255">
                                    <div class="form-text">Maximum 255 characters</div>
                                </div>

                                <div class="mb-3">
                                    <label for="message" class="form-label">Message <span class="text-danger">*</span></label>
                                    <textarea class="form-control" id="message" name="message" rows="3" required maxlength="500">{{ old('message') }}</textarea>
                                    <div class="form-text">Maximum 500 characters</div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="icon" class="form-label">Icon URL</label>
                                            <input type="url" class="form-control" id="icon" name="icon" value="{{ old('icon') }}">
                                            <div class="form-text">URL to notification icon (optional)</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="image_file" class="form-label">Upload Image</label>
                                            <input type="file" class="form-control" id="image_file" name="image_file" accept="image/*">
                                            <div class="form-text">Or upload an image file</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="image_url" class="form-label">Image URL</label>
                                    <input type="url" class="form-control" id="image_url" name="image_url" value="{{ old('image_url') }}">
                                    <div class="form-text">URL to notification image (optional)</div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="action_url" class="form-label">Action URL</label>
                                            <input type="url" class="form-control" id="action_url" name="action_url" value="{{ old('action_url') }}">
                                            <div class="form-text">URL to open when notification is clicked</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="action_text" class="form-label">Action Button Text</label>
                                            <input type="text" class="form-control" id="action_text" name="action_text" value="{{ old('action_text') }}" maxlength="100">
                                            <div class="form-text">Text for action button (optional)</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Targeting</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="target_audience" class="form-label">Target Audience <span class="text-danger">*</span></label>
                                    <select class="form-select" id="target_audience" name="target_audience" required>
                                        <option value="all" {{ old('target_audience') === 'all' ? 'selected' : '' }}>All Users</option>
                                        <option value="registered" {{ old('target_audience') === 'registered' ? 'selected' : '' }}>Registered Users Only</option>
                                        <option value="premium" {{ old('target_audience') === 'premium' ? 'selected' : '' }}>Premium Users Only</option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Categories</label>
                                    <div class="row">
                                        @foreach($categories as $category)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_categories[]" value="{{ $category }}" id="cat_{{ $category }}" {{ in_array($category, old('target_categories', [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="cat_{{ $category }}">
                                                        {{ ucfirst($category) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all categories</div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Locations</label>
                                    <div class="row">
                                        @foreach($locations as $location)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_locations[]" value="{{ $location }}" id="loc_{{ $location }}" {{ in_array($location, old('target_locations', [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="loc_{{ $location }}">
                                                        {{ ucfirst($location) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all locations</div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Interests</label>
                                    <div class="row">
                                        @foreach($interests as $interest)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_interests[]" value="{{ $interest }}" id="int_{{ $interest }}" {{ in_array($interest, old('target_interests', [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="int_{{ $interest }}">
                                                        {{ ucfirst($interest) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all interests</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Scheduling</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="is_immediate" name="is_immediate" value="1" {{ old('is_immediate') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_immediate">
                                            Send Immediately
                                        </label>
                                    </div>
                                </div>

                                <div class="mb-3" id="scheduled_at_group">
                                    <label for="scheduled_at" class="form-label">Schedule Date & Time</label>
                                    <input type="datetime-local" class="form-control" id="scheduled_at" name="scheduled_at" value="{{ old('scheduled_at') }}">
                                </div>

                                <div class="mb-3">
                                    <label for="expires_at" class="form-label">Expires At</label>
                                    <input type="datetime-local" class="form-control" id="expires_at" name="expires_at" value="{{ old('expires_at') }}">
                                    <div class="form-text">Optional expiration date</div>
                                </div>

                                <div class="mb-3">
                                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                    <select class="form-select" id="status" name="status" required>
                                        <option value="draft" {{ old('status') === 'draft' ? 'selected' : '' }}>Draft</option>
                                        <option value="scheduled" {{ old('status') === 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Preview</h5>
                            </div>
                            <div class="card-body">
                                <div class="notification-preview">
                                    <div class="d-flex align-items-start">
                                        <div class="notification-icon me-3">
                                            <i class="fas fa-bell fa-lg text-primary"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="notification-title fw-bold" id="preview-title">Campaign Title</div>
                                            <div class="notification-message text-muted" id="preview-message">Campaign message will appear here...</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                                        Cancel
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save"></i> Create Campaign
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const immediateCheckbox = document.getElementById('is_immediate');
    const scheduledGroup = document.getElementById('scheduled_at_group');
    const titleInput = document.getElementById('title');
    const messageInput = document.getElementById('message');
    const previewTitle = document.getElementById('preview-title');
    const previewMessage = document.getElementById('preview-message');

    // Toggle scheduled date visibility
    function toggleScheduledGroup() {
        if (immediateCheckbox.checked) {
            scheduledGroup.style.display = 'none';
        } else {
            scheduledGroup.style.display = 'block';
        }
    }

    immediateCheckbox.addEventListener('change', toggleScheduledGroup);
    toggleScheduledGroup();

    // Update preview
    function updatePreview() {
        previewTitle.textContent = titleInput.value || 'Campaign Title';
        previewMessage.textContent = messageInput.value || 'Campaign message will appear here...';
    }

    titleInput.addEventListener('input', updatePreview);
    messageInput.addEventListener('input', updatePreview);
});
</script>
@endsection


@section('title', 'Create Notification Campaign')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Create Notification Campaign</h1>
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Campaigns
                </a>
            </div>

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <form action="{{ route('admin.notifications.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Campaign Details</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}" required maxlength="255">
                                    <div class="form-text">Maximum 255 characters</div>
                                </div>

                                <div class="mb-3">
                                    <label for="message" class="form-label">Message <span class="text-danger">*</span></label>
                                    <textarea class="form-control" id="message" name="message" rows="3" required maxlength="500">{{ old('message') }}</textarea>
                                    <div class="form-text">Maximum 500 characters</div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="icon" class="form-label">Icon URL</label>
                                            <input type="url" class="form-control" id="icon" name="icon" value="{{ old('icon') }}">
                                            <div class="form-text">URL to notification icon (optional)</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="image_file" class="form-label">Upload Image</label>
                                            <input type="file" class="form-control" id="image_file" name="image_file" accept="image/*">
                                            <div class="form-text">Or upload an image file</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="image_url" class="form-label">Image URL</label>
                                    <input type="url" class="form-control" id="image_url" name="image_url" value="{{ old('image_url') }}">
                                    <div class="form-text">URL to notification image (optional)</div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="action_url" class="form-label">Action URL</label>
                                            <input type="url" class="form-control" id="action_url" name="action_url" value="{{ old('action_url') }}">
                                            <div class="form-text">URL to open when notification is clicked</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="action_text" class="form-label">Action Button Text</label>
                                            <input type="text" class="form-control" id="action_text" name="action_text" value="{{ old('action_text') }}" maxlength="100">
                                            <div class="form-text">Text for action button (optional)</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Targeting</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="target_audience" class="form-label">Target Audience <span class="text-danger">*</span></label>
                                    <select class="form-select" id="target_audience" name="target_audience" required>
                                        <option value="all" {{ old('target_audience') === 'all' ? 'selected' : '' }}>All Users</option>
                                        <option value="registered" {{ old('target_audience') === 'registered' ? 'selected' : '' }}>Registered Users Only</option>
                                        <option value="premium" {{ old('target_audience') === 'premium' ? 'selected' : '' }}>Premium Users Only</option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Categories</label>
                                    <div class="row">
                                        @foreach($categories as $category)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_categories[]" value="{{ $category }}" id="cat_{{ $category }}" {{ in_array($category, old('target_categories', [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="cat_{{ $category }}">
                                                        {{ ucfirst($category) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all categories</div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Locations</label>
                                    <div class="row">
                                        @foreach($locations as $location)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_locations[]" value="{{ $location }}" id="loc_{{ $location }}" {{ in_array($location, old('target_locations', [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="loc_{{ $location }}">
                                                        {{ ucfirst($location) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all locations</div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Interests</label>
                                    <div class="row">
                                        @foreach($interests as $interest)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_interests[]" value="{{ $interest }}" id="int_{{ $interest }}" {{ in_array($interest, old('target_interests', [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="int_{{ $interest }}">
                                                        {{ ucfirst($interest) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all interests</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Scheduling</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="is_immediate" name="is_immediate" value="1" {{ old('is_immediate') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_immediate">
                                            Send Immediately
                                        </label>
                                    </div>
                                </div>

                                <div class="mb-3" id="scheduled_at_group">
                                    <label for="scheduled_at" class="form-label">Schedule Date & Time</label>
                                    <input type="datetime-local" class="form-control" id="scheduled_at" name="scheduled_at" value="{{ old('scheduled_at') }}">
                                </div>

                                <div class="mb-3">
                                    <label for="expires_at" class="form-label">Expires At</label>
                                    <input type="datetime-local" class="form-control" id="expires_at" name="expires_at" value="{{ old('expires_at') }}">
                                    <div class="form-text">Optional expiration date</div>
                                </div>

                                <div class="mb-3">
                                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                    <select class="form-select" id="status" name="status" required>
                                        <option value="draft" {{ old('status') === 'draft' ? 'selected' : '' }}>Draft</option>
                                        <option value="scheduled" {{ old('status') === 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Preview</h5>
                            </div>
                            <div class="card-body">
                                <div class="notification-preview">
                                    <div class="d-flex align-items-start">
                                        <div class="notification-icon me-3">
                                            <i class="fas fa-bell fa-lg text-primary"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="notification-title fw-bold" id="preview-title">Campaign Title</div>
                                            <div class="notification-message text-muted" id="preview-message">Campaign message will appear here...</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                                        Cancel
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save"></i> Create Campaign
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const immediateCheckbox = document.getElementById('is_immediate');
    const scheduledGroup = document.getElementById('scheduled_at_group');
    const titleInput = document.getElementById('title');
    const messageInput = document.getElementById('message');
    const previewTitle = document.getElementById('preview-title');
    const previewMessage = document.getElementById('preview-message');

    // Toggle scheduled date visibility
    function toggleScheduledGroup() {
        if (immediateCheckbox.checked) {
            scheduledGroup.style.display = 'none';
        } else {
            scheduledGroup.style.display = 'block';
        }
    }

    immediateCheckbox.addEventListener('change', toggleScheduledGroup);
    toggleScheduledGroup();

    // Update preview
    function updatePreview() {
        previewTitle.textContent = titleInput.value || 'Campaign Title';
        previewMessage.textContent = messageInput.value || 'Campaign message will appear here...';
    }

    titleInput.addEventListener('input', updatePreview);
    messageInput.addEventListener('input', updatePreview);
});
</script>
@endsection
