@extends('admin.layout')

@section('title', 'Edit Notification Campaign')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Edit Notification Campaign</h1>
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Campaigns
                </a>
            </div>

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <form action="{{ route('admin.notifications.update', $notification) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Campaign Details</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="title" name="title" value="{{ old('title', $notification->title) }}" required maxlength="255">
                                    <div class="form-text">Maximum 255 characters</div>
                                </div>

                                <div class="mb-3">
                                    <label for="message" class="form-label">Message <span class="text-danger">*</span></label>
                                    <textarea class="form-control" id="message" name="message" rows="3" required maxlength="500">{{ old('message', $notification->message) }}</textarea>
                                    <div class="form-text">Maximum 500 characters</div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="icon" class="form-label">Icon URL</label>
                                            <input type="url" class="form-control" id="icon" name="icon" value="{{ old('icon', $notification->icon) }}">
                                            <div class="form-text">URL to notification icon (optional)</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="image_file" class="form-label">Upload New Image</label>
                                            <input type="file" class="form-control" id="image_file" name="image_file" accept="image/*">
                                            <div class="form-text">Or upload a new image file</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="image_url" class="form-label">Image URL</label>
                                    <input type="url" class="form-control" id="image_url" name="image_url" value="{{ old('image_url', $notification->image_url) }}">
                                    <div class="form-text">URL to notification image (optional)</div>
                                    @if($notification->image_url)
                                        <div class="mt-2">
                                            <img src="{{ $notification->image_url }}" alt="Current image" class="img-thumbnail" style="max-width: 200px;">
                                        </div>
                                    @endif
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="action_url" class="form-label">Action URL</label>
                                            <input type="url" class="form-control" id="action_url" name="action_url" value="{{ old('action_url', $notification->action_url) }}">
                                            <div class="form-text">URL to open when notification is clicked</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="action_text" class="form-label">Action Button Text</label>
                                            <input type="text" class="form-control" id="action_text" name="action_text" value="{{ old('action_text', $notification->action_text) }}" maxlength="100">
                                            <div class="form-text">Text for action button (optional)</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Targeting</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="target_audience" class="form-label">Target Audience <span class="text-danger">*</span></label>
                                    <select class="form-select" id="target_audience" name="target_audience" required>
                                        <option value="all" {{ old('target_audience', $notification->target_audience) === 'all' ? 'selected' : '' }}>All Users</option>
                                        <option value="registered" {{ old('target_audience', $notification->target_audience) === 'registered' ? 'selected' : '' }}>Registered Users Only</option>
                                        <option value="premium" {{ old('target_audience', $notification->target_audience) === 'premium' ? 'selected' : '' }}>Premium Users Only</option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Categories</label>
                                    <div class="row">
                                        @foreach($categories as $category)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_categories[]" value="{{ $category }}" id="cat_{{ $category }}" {{ in_array($category, old('target_categories', $notification->target_categories ?? [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="cat_{{ $category }}">
                                                        {{ ucfirst($category) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all categories</div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Locations</label>
                                    <div class="row">
                                        @foreach($locations as $location)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_locations[]" value="{{ $location }}" id="loc_{{ $location }}" {{ in_array($location, old('target_locations', $notification->target_locations ?? [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="loc_{{ $location }}">
                                                        {{ ucfirst($location) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all locations</div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Interests</label>
                                    <div class="row">
                                        @foreach($interests as $interest)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_interests[]" value="{{ $interest }}" id="int_{{ $interest }}" {{ in_array($interest, old('target_interests', $notification->target_interests ?? [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="int_{{ $interest }}">
                                                        {{ ucfirst($interest) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all interests</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Scheduling</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="is_immediate" name="is_immediate" value="1" {{ old('is_immediate', $notification->is_immediate) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_immediate">
                                            Send Immediately
                                        </label>
                                    </div>
                                </div>

                                <div class="mb-3" id="scheduled_at_group">
                                    <label for="scheduled_at" class="form-label">Schedule Date & Time</label>
                                    <input type="datetime-local" class="form-control" id="scheduled_at" name="scheduled_at" value="{{ old('scheduled_at', $notification->scheduled_at ? $notification->scheduled_at->format('Y-m-d\TH:i') : '') }}">
                                </div>

                                <div class="mb-3">
                                    <label for="expires_at" class="form-label">Expires At</label>
                                    <input type="datetime-local" class="form-control" id="expires_at" name="expires_at" value="{{ old('expires_at', $notification->expires_at ? $notification->expires_at->format('Y-m-d\TH:i') : '') }}">
                                    <div class="form-text">Optional expiration date</div>
                                </div>

                                <div class="mb-3">
                                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                    <select class="form-select" id="status" name="status" required>
                                        <option value="draft" {{ old('status', $notification->status) === 'draft' ? 'selected' : '' }}>Draft</option>
                                        <option value="scheduled" {{ old('status', $notification->status) === 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                        @if($notification->status === 'sent')
                                            <option value="sent" selected>Sent</option>
                                        @endif
                                        @if($notification->status === 'cancelled')
                                            <option value="cancelled" selected>Cancelled</option>
                                        @endif
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Campaign Stats</h5>
                            </div>
                            <div class="card-body">
                                <div class="row text-center">
                                    <div class="col-6">
                                        <div class="stat-item">
                                            <h4 class="text-primary">{{ number_format($notification->sent_count) }}</h4>
                                            <small class="text-muted">Sent</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="stat-item">
                                            <h4 class="text-success">{{ number_format($notification->delivered_count) }}</h4>
                                            <small class="text-muted">Delivered</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="stat-item">
                                            <h4 class="text-warning">{{ number_format($notification->clicked_count) }}</h4>
                                            <small class="text-muted">Clicked</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="stat-item">
                                            <h4 class="text-info">{{ number_format($notification->converted_count) }}</h4>
                                            <small class="text-muted">Converted</small>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="row text-center">
                                    <div class="col-6">
                                        <small class="text-muted">Delivery Rate</small>
                                        <div class="fw-bold">{{ $notification->delivery_rate }}%</div>
                                    </div>
                                    <div class="col-6">
                                        <small class="text-muted">Click Rate</small>
                                        <div class="fw-bold">{{ $notification->click_rate }}%</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                                        Cancel
                                    </a>
                                    <div>
                                        @if($notification->status === 'scheduled')
                                            <form action="{{ route('admin.notifications.send', $notification) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-success me-2" onclick="return confirm('Are you sure you want to send this campaign?')">
                                                    <i class="fas fa-paper-plane"></i> Send Now
                                                </button>
                                            </form>
                                        @endif
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save"></i> Update Campaign
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const immediateCheckbox = document.getElementById('is_immediate');
    const scheduledGroup = document.getElementById('scheduled_at_group');
    const titleInput = document.getElementById('title');
    const messageInput = document.getElementById('message');

    // Toggle scheduled date visibility
    function toggleScheduledGroup() {
        if (immediateCheckbox.checked) {
            scheduledGroup.style.display = 'none';
        } else {
            scheduledGroup.style.display = 'block';
        }
    }

    immediateCheckbox.addEventListener('change', toggleScheduledGroup);
    toggleScheduledGroup();
});
</script>
@endsection


@section('title', 'Edit Notification Campaign')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Edit Notification Campaign</h1>
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Campaigns
                </a>
            </div>

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <form action="{{ route('admin.notifications.update', $notification) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Campaign Details</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="title" name="title" value="{{ old('title', $notification->title) }}" required maxlength="255">
                                    <div class="form-text">Maximum 255 characters</div>
                                </div>

                                <div class="mb-3">
                                    <label for="message" class="form-label">Message <span class="text-danger">*</span></label>
                                    <textarea class="form-control" id="message" name="message" rows="3" required maxlength="500">{{ old('message', $notification->message) }}</textarea>
                                    <div class="form-text">Maximum 500 characters</div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="icon" class="form-label">Icon URL</label>
                                            <input type="url" class="form-control" id="icon" name="icon" value="{{ old('icon', $notification->icon) }}">
                                            <div class="form-text">URL to notification icon (optional)</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="image_file" class="form-label">Upload New Image</label>
                                            <input type="file" class="form-control" id="image_file" name="image_file" accept="image/*">
                                            <div class="form-text">Or upload a new image file</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="image_url" class="form-label">Image URL</label>
                                    <input type="url" class="form-control" id="image_url" name="image_url" value="{{ old('image_url', $notification->image_url) }}">
                                    <div class="form-text">URL to notification image (optional)</div>
                                    @if($notification->image_url)
                                        <div class="mt-2">
                                            <img src="{{ $notification->image_url }}" alt="Current image" class="img-thumbnail" style="max-width: 200px;">
                                        </div>
                                    @endif
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="action_url" class="form-label">Action URL</label>
                                            <input type="url" class="form-control" id="action_url" name="action_url" value="{{ old('action_url', $notification->action_url) }}">
                                            <div class="form-text">URL to open when notification is clicked</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="action_text" class="form-label">Action Button Text</label>
                                            <input type="text" class="form-control" id="action_text" name="action_text" value="{{ old('action_text', $notification->action_text) }}" maxlength="100">
                                            <div class="form-text">Text for action button (optional)</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Targeting</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="target_audience" class="form-label">Target Audience <span class="text-danger">*</span></label>
                                    <select class="form-select" id="target_audience" name="target_audience" required>
                                        <option value="all" {{ old('target_audience', $notification->target_audience) === 'all' ? 'selected' : '' }}>All Users</option>
                                        <option value="registered" {{ old('target_audience', $notification->target_audience) === 'registered' ? 'selected' : '' }}>Registered Users Only</option>
                                        <option value="premium" {{ old('target_audience', $notification->target_audience) === 'premium' ? 'selected' : '' }}>Premium Users Only</option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Categories</label>
                                    <div class="row">
                                        @foreach($categories as $category)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_categories[]" value="{{ $category }}" id="cat_{{ $category }}" {{ in_array($category, old('target_categories', $notification->target_categories ?? [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="cat_{{ $category }}">
                                                        {{ ucfirst($category) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all categories</div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Locations</label>
                                    <div class="row">
                                        @foreach($locations as $location)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_locations[]" value="{{ $location }}" id="loc_{{ $location }}" {{ in_array($location, old('target_locations', $notification->target_locations ?? [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="loc_{{ $location }}">
                                                        {{ ucfirst($location) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all locations</div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Target Interests</label>
                                    <div class="row">
                                        @foreach($interests as $interest)
                                            <div class="col-md-4 col-lg-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="target_interests[]" value="{{ $interest }}" id="int_{{ $interest }}" {{ in_array($interest, old('target_interests', $notification->target_interests ?? [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="int_{{ $interest }}">
                                                        {{ ucfirst($interest) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="form-text">Leave empty to target all interests</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Scheduling</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="is_immediate" name="is_immediate" value="1" {{ old('is_immediate', $notification->is_immediate) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_immediate">
                                            Send Immediately
                                        </label>
                                    </div>
                                </div>

                                <div class="mb-3" id="scheduled_at_group">
                                    <label for="scheduled_at" class="form-label">Schedule Date & Time</label>
                                    <input type="datetime-local" class="form-control" id="scheduled_at" name="scheduled_at" value="{{ old('scheduled_at', $notification->scheduled_at ? $notification->scheduled_at->format('Y-m-d\TH:i') : '') }}">
                                </div>

                                <div class="mb-3">
                                    <label for="expires_at" class="form-label">Expires At</label>
                                    <input type="datetime-local" class="form-control" id="expires_at" name="expires_at" value="{{ old('expires_at', $notification->expires_at ? $notification->expires_at->format('Y-m-d\TH:i') : '') }}">
                                    <div class="form-text">Optional expiration date</div>
                                </div>

                                <div class="mb-3">
                                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                    <select class="form-select" id="status" name="status" required>
                                        <option value="draft" {{ old('status', $notification->status) === 'draft' ? 'selected' : '' }}>Draft</option>
                                        <option value="scheduled" {{ old('status', $notification->status) === 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                        @if($notification->status === 'sent')
                                            <option value="sent" selected>Sent</option>
                                        @endif
                                        @if($notification->status === 'cancelled')
                                            <option value="cancelled" selected>Cancelled</option>
                                        @endif
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Campaign Stats</h5>
                            </div>
                            <div class="card-body">
                                <div class="row text-center">
                                    <div class="col-6">
                                        <div class="stat-item">
                                            <h4 class="text-primary">{{ number_format($notification->sent_count) }}</h4>
                                            <small class="text-muted">Sent</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="stat-item">
                                            <h4 class="text-success">{{ number_format($notification->delivered_count) }}</h4>
                                            <small class="text-muted">Delivered</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="stat-item">
                                            <h4 class="text-warning">{{ number_format($notification->clicked_count) }}</h4>
                                            <small class="text-muted">Clicked</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="stat-item">
                                            <h4 class="text-info">{{ number_format($notification->converted_count) }}</h4>
                                            <small class="text-muted">Converted</small>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="row text-center">
                                    <div class="col-6">
                                        <small class="text-muted">Delivery Rate</small>
                                        <div class="fw-bold">{{ $notification->delivery_rate }}%</div>
                                    </div>
                                    <div class="col-6">
                                        <small class="text-muted">Click Rate</small>
                                        <div class="fw-bold">{{ $notification->click_rate }}%</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                                        Cancel
                                    </a>
                                    <div>
                                        @if($notification->status === 'scheduled')
                                            <form action="{{ route('admin.notifications.send', $notification) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-success me-2" onclick="return confirm('Are you sure you want to send this campaign?')">
                                                    <i class="fas fa-paper-plane"></i> Send Now
                                                </button>
                                            </form>
                                        @endif
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save"></i> Update Campaign
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const immediateCheckbox = document.getElementById('is_immediate');
    const scheduledGroup = document.getElementById('scheduled_at_group');
    const titleInput = document.getElementById('title');
    const messageInput = document.getElementById('message');

    // Toggle scheduled date visibility
    function toggleScheduledGroup() {
        if (immediateCheckbox.checked) {
            scheduledGroup.style.display = 'none';
        } else {
            scheduledGroup.style.display = 'block';
        }
    }

    immediateCheckbox.addEventListener('change', toggleScheduledGroup);
    toggleScheduledGroup();
});
</script>
@endsection
