@extends('admin.layout')

@section('title', 'AI Settings')

@section('content')
<div class="admin-header">
    <h1 class="mb-0">
        <i class="fas fa-cog"></i> AI Settings
    </h1>
    <p class="text-muted mb-0">Configure your chatbot's AI behavior and performance</p>
</div>

<form action="{{ route('admin.settings.update') }}" method="POST">
    @csrf
    @method('PUT')

    <!-- AI Behavior Settings -->
    <div class="admin-card">
        <h5 class="mb-3"><i class="fas fa-brain"></i> AI Behavior Settings</h5>
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="ai_temperature" class="form-label">AI Temperature</label>
                    <input type="range" class="form-range" id="ai_temperature" name="ai_temperature" 
                           min="0" max="2" step="0.1" 
                           value="{{ $aiSettings->where('setting_key', 'ai_temperature')->first()->setting_value ?? $defaultAISettings['ai_temperature'] }}"
                           oninput="updateTemperatureValue(this.value)">
                    <div class="d-flex justify-content-between">
                        <small class="text-muted">Conservative (0.0)</small>
                        <small class="text-muted">Balanced (1.0)</small>
                        <small class="text-muted">Creative (2.0)</small>
                    </div>
                    <div class="text-center mt-2">
                        <strong>Current: <span id="temperature_value">0.2</span></strong>
                    </div>
                    <div class="form-text">
                        Lower values = more focused, consistent responses. Higher values = more creative, varied responses.
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="ai_max_tokens" class="form-label">Max Response Tokens</label>
                    <input type="range" class="form-range" id="ai_max_tokens" name="ai_max_tokens" 
                           min="50" max="1000" step="50" 
                           value="{{ $aiSettings->where('setting_key', 'ai_max_tokens')->first()->setting_value ?? $defaultAISettings['ai_max_tokens'] }}"
                           oninput="updateTokenValue(this.value)">
                    <div class="d-flex justify-content-between">
                        <small class="text-muted">Short (50)</small>
                        <small class="text-muted">Medium (500)</small>
                        <small class="text-muted">Long (1000)</small>
                    </div>
                    <div class="text-center mt-2">
                        <strong>Current: <span id="token_value">150</span></strong>
                    </div>
                    <div class="form-text">
                        Controls the maximum length of AI responses. Lower = more concise.
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="ai_model" class="form-label">OpenAI Model</label>
                    <select class="form-select" id="ai_model" name="ai_model">
                        <option value="gpt-3.5-turbo" {{ ($aiSettings->where('setting_key', 'ai_model')->first()->setting_value ?? $defaultAISettings['ai_model']) == 'gpt-3.5-turbo' ? 'selected' : '' }}>
                            GPT-3.5 Turbo (Fast, Cost-effective)
                        </option>
                        <option value="gpt-4-turbo" {{ ($aiSettings->where('setting_key', 'ai_model')->first()->setting_value ?? $defaultAISettings['ai_model']) == 'gpt-4-turbo' ? 'selected' : '' }}>
                            GPT-4 Turbo (Smart, Accurate)
                        </option>
                        <option value="gpt-4o" {{ ($aiSettings->where('setting_key', 'ai_model')->first()->setting_value ?? $defaultAISettings['ai_model']) == 'gpt-4o' ? 'selected' : '' }}>
                            GPT-4o (Latest, Most Capable)
                        </option>
                        <option value="gpt-4o-mini-search-preview" {{ ($aiSettings->where('setting_key', 'ai_model')->first()->setting_value ?? $defaultAISettings['ai_model']) == 'gpt-4o-mini-search-preview' ? 'selected' : '' }}>
                            GPT-4o Mini Search (Web Search Enabled) 🚀
                        </option>
                        <option value="gpt-5-mini" {{ ($aiSettings->where('setting_key', 'ai_model')->first()->setting_value ?? $defaultAISettings['ai_model']) == 'gpt-5-mini' ? 'selected' : '' }}>
                            GPT-5 Mini (Web Search Enabled) 🚀
                        </option>
                    </select>
                    <div class="form-text">
                        Choose the AI model for your chatbot. GPT-5 Mini includes web search for real-time information! 🚀
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="ai_response_speed" class="form-label">Response Speed Priority</label>
                    <select class="form-select" id="ai_response_speed" name="ai_response_speed">
                        <option value="fast" {{ ($aiSettings->where('setting_key', 'ai_response_speed')->first()->setting_value ?? 'balanced') == 'fast' ? 'selected' : '' }}>
                            Fast (Lower quality, quick responses)
                        </option>
                        <option value="balanced" {{ ($aiSettings->where('setting_key', 'ai_response_speed')->first()->setting_value ?? 'balanced') == 'balanced' ? 'selected' : '' }}>
                            Balanced (Good quality, moderate speed)
                        </option>
                        <option value="quality" {{ ($aiSettings->where('setting_key', 'ai_response_speed')->first()->setting_value ?? 'balanced') == 'quality' ? 'selected' : '' }}>
                            Quality (Best quality, slower responses)
                        </option>
                    </select>
                    <div class="form-text">
                        Balance between response quality and speed.
                    </div>
                </div>
            </div>
        </div>

        <!-- Web Search Toggle -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="ai_web_search_enabled" name="ai_web_search_enabled" 
                               value="true" {{ ($aiSettings->where('setting_key', 'ai_web_search_enabled')->first()->setting_value ?? 'true') == 'true' ? 'checked' : '' }}>
                        <label class="form-check-label" for="ai_web_search_enabled">
                            <strong>Enable Web Search Capabilities</strong>
                        </label>
                    </div>
                    <div class="form-text">
                        <i class="fas fa-info-circle text-info"></i> 
                        When enabled, the chatbot can search the web for real-time information. 
                        <strong>Requires a search-enabled model</strong> (GPT-4o Mini Search or GPT-5 Mini).
                        <br>
                        <small class="text-muted">
                            <strong>ON:</strong> Uses web search for current information + database news<br>
                            <strong>OFF:</strong> Uses only database news + regular AI responses
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Chat Behavior Settings -->
    <div class="admin-card">
        <h5 class="mb-3"><i class="fas fa-comments"></i> Chat Behavior Settings</h5>
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="chat_context_length" class="form-label">Context Memory Length</label>
                    <select class="form-select" id="chat_context_length" name="chat_context_length">
                        <option value="short" {{ ($behaviorSettings->where('setting_key', 'chat_context_length')->first()->setting_value ?? 'medium') == 'short' ? 'selected' : '' }}>
                            Short (3-5 messages)
                        </option>
                        <option value="medium" {{ ($behaviorSettings->where('setting_key', 'chat_context_length')->first()->setting_value ?? 'medium') == 'medium' ? 'selected' : '' }}>
                            Medium (5-10 messages)
                        </option>
                        <option value="long" {{ ($behaviorSettings->where('setting_key', 'chat_context_length')->first()->setting_value ?? 'medium') == 'long' ? 'selected' : '' }}>
                            Long (10+ messages)
                        </option>
                    </select>
                    <div class="form-text">
                        How many previous messages the AI remembers for context.
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="chat_personality" class="form-label">Chatbot Personality</label>
                    <select class="form-select" id="chat_personality" name="chat_personality">
                        <option value="professional" {{ ($behaviorSettings->where('setting_key', 'chat_personality')->first()->setting_value ?? 'friendly') == 'professional' ? 'selected' : '' }}>
                            Professional (Formal, business-like)
                        </option>
                        <option value="friendly" {{ ($behaviorSettings->where('setting_key', 'chat_personality')->first()->setting_value ?? 'friendly') == 'friendly' ? 'selected' : '' }}>
                            Friendly (Casual, approachable)
                        </option>
                        <option value="enthusiastic" {{ ($behaviorSettings->where('setting_key', 'chat_personality')->first()->setting_value ?? 'friendly') == 'enthusiastic' ? 'selected' : '' }}>
                            Enthusiastic (Energetic, excited)
                        </option>
                        <option value="calm" {{ ($behaviorSettings->where('setting_key', 'chat_personality')->first()->setting_value ?? 'friendly') == 'calm' ? 'selected' : '' }}>
                            Calm (Relaxed, soothing)
                        </option>
                    </select>
                    <div class="form-text">
                        The tone and personality of your chatbot's responses.
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="news_summary_length" class="form-label">News Summary Length</label>
                    <select class="form-select" id="news_summary_length" name="news_summary_length">
                        <option value="brief" {{ ($behaviorSettings->where('setting_key', 'news_summary_length')->first()->setting_value ?? 'concise') == 'brief' ? 'selected' : '' }}>
                            Brief (1-2 sentences)
                        </option>
                        <option value="concise" {{ ($behaviorSettings->where('setting_key', 'news_summary_length')->first()->setting_value ?? 'concise') == 'concise' ? 'selected' : '' }}>
                            Concise (2-3 sentences)
                        </option>
                        <option value="detailed" {{ ($behaviorSettings->where('setting_key', 'news_summary_length')->first()->setting_value ?? 'concise') == 'detailed' ? 'selected' : '' }}>
                            Detailed (3-5 sentences)
                        </option>
                    </select>
                    <div class="form-text">
                        How detailed news summaries should be.
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="auto_suggestions" class="form-label">Auto Suggestions</label>
                    <select class="form-select" id="auto_suggestions" name="auto_suggestions">
                        <option value="enabled" {{ ($behaviorSettings->where('setting_key', 'auto_suggestions')->first()->setting_value ?? 'enabled') == 'enabled' ? 'selected' : '' }}>
                            Enabled (Show follow-up suggestions)
                        </option>
                        <option value="disabled" {{ ($behaviorSettings->where('setting_key', 'auto_suggestions')->first()->setting_value ?? 'enabled') == 'disabled' ? 'selected' : '' }}>
                            Disabled (No suggestions)
                        </option>
                    </select>
                    <div class="form-text">
                        Whether to show suggested follow-up questions.
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- UI Settings -->
    <div class="admin-card">
        <h5 class="mb-3"><i class="fas fa-desktop"></i> User Interface Settings</h5>
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="typing_speed" class="form-label">Typing Animation Speed</label>
                    <select class="form-select" id="typing_speed" name="typing_speed">
                        <option value="slow" {{ ($uiSettings->where('setting_key', 'typing_speed')->first()->setting_value ?? 'medium') == 'slow' ? 'selected' : '' }}>
                            Slow (50ms per character)
                        </option>
                        <option value="medium" {{ ($uiSettings->where('setting_key', 'typing_speed')->first()->setting_value ?? 'medium') == 'medium' ? 'selected' : '' }}>
                            Medium (30ms per character)
                        </option>
                        <option value="fast" {{ ($uiSettings->where('setting_key', 'typing_speed')->first()->setting_value ?? 'medium') == 'fast' ? 'selected' : '' }}>
                            Fast (15ms per character)
                        </option>
                        <option value="instant" {{ ($uiSettings->where('setting_key', 'typing_speed')->first()->setting_value ?? 'medium') == 'instant' ? 'selected' : '' }}>
                            Instant (No animation)
                        </option>
                    </select>
                    <div class="form-text">
                        Speed of the typing animation effect.
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="ad_display_delay" class="form-label">Ad Display Delay</label>
                    <select class="form-select" id="ad_display_delay" name="ad_display_delay">
                        <option value="immediate" {{ ($uiSettings->where('setting_key', 'ad_display_delay')->first()->setting_value ?? 'short') == 'immediate' ? 'selected' : '' }}>
                            Immediate (0ms)
                        </option>
                        <option value="short" {{ ($uiSettings->where('setting_key', 'ad_display_delay')->first()->setting_value ?? 'short') == 'short' ? 'selected' : '' }}>
                            Short (1000ms)
                        </option>
                        <option value="medium" {{ ($uiSettings->where('setting_key', 'ad_display_delay')->first()->setting_value ?? 'short') == 'medium' ? 'selected' : '' }}>
                            Medium (1500ms)
                        </option>
                        <option value="long" {{ ($uiSettings->where('setting_key', 'ad_display_delay')->first()->setting_value ?? 'short') == 'long' ? 'selected' : '' }}>
                            Long (2000ms)
                        </option>
                    </select>
                    <div class="form-text">
                        How long to wait before showing ads during AI thinking.
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="ad_frequency" class="form-label">Ad Display Frequency</label>
                    <select class="form-select" id="ad_frequency" name="ad_frequency">
                        <option value="every" {{ ($uiSettings->where('setting_key', 'ad_frequency')->first()->setting_value ?? 'every') == 'every' ? 'selected' : '' }}>
                            Every Query (Show ad after each user message)
                        </option>
                        <option value="every_2" {{ ($uiSettings->where('setting_key', 'ad_frequency')->first()->setting_value ?? 'every') == 'every_2' ? 'selected' : '' }}>
                            Every 2nd Query (Show ad every other message)
                        </option>
                        <option value="every_3" {{ ($uiSettings->where('setting_key', 'ad_frequency')->first()->setting_value ?? 'every') == 'every_3' ? 'selected' : '' }}>
                            Every 3rd Query (Show ad every third message)
                        </option>
                        <option value="every_5" {{ ($uiSettings->where('setting_key', 'ad_frequency')->first()->setting_value ?? 'every') == 'every_5' ? 'selected' : '' }}>
                            Every 5th Query (Show ad every fifth message)
                        </option>
                        <option value="random" {{ ($uiSettings->where('setting_key', 'ad_frequency')->first()->setting_value ?? 'every') == 'random' ? 'selected' : '' }}>
                            Random (Show ad randomly, ~30% chance)
                        </option>
                        <option value="disabled" {{ ($uiSettings->where('setting_key', 'ad_frequency')->first()->setting_value ?? 'every') == 'disabled' ? 'selected' : '' }}>
                            Disabled (No ads shown)
                        </option>
                    </select>
                    <div class="form-text">
                        Control how often ads are displayed to users. More frequent = higher revenue but may impact user experience.
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="auto_scroll" class="form-label">Auto-scroll Behavior</label>
                    <select class="form-select" id="auto_scroll" name="auto_scroll">
                        <option value="enabled" {{ ($uiSettings->where('setting_key', 'auto_scroll')->first()->setting_value ?? 'enabled') == 'enabled' ? 'selected' : '' }}>
                            Enabled (Auto-scroll to new messages)
                        </option>
                        <option value="disabled" {{ ($uiSettings->where('setting_key', 'auto_scroll')->first()->setting_value ?? 'enabled') == 'disabled' ? 'selected' : '' }}>
                            Disabled (Manual scrolling)
                        </option>
                    </select>
                    <div class="form-text">
                        Whether to automatically scroll to new messages.
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="sound_notifications" class="form-label">Sound Notifications</label>
                    <select class="form-select" id="sound_notifications" name="sound_notifications">
                        <option value="enabled" {{ ($uiSettings->where('setting_key', 'sound_notifications')->first()->setting_value ?? 'disabled') == 'enabled' ? 'selected' : '' }}>
                            Enabled (Play sounds for new messages)
                        </option>
                        <option value="disabled" {{ ($uiSettings->where('setting_key', 'sound_notifications')->first()->setting_value ?? 'disabled') == 'disabled' ? 'selected' : '' }}>
                            Disabled (No sounds)
                        </option>
                    </select>
                    <div class="form-text">
                        Audio feedback for new messages and AI responses.
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Save Button -->
    <div class="admin-card">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h5 class="mb-0"><i class="fas fa-save"></i> Save Settings</h5>
                <p class="text-muted mb-0">Your changes will take effect immediately</p>
            </div>
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fas fa-save"></i> Save All Settings
            </button>
        </div>
    </div>
</form>

<!-- Current Configuration Summary -->
<div class="admin-card">
    <h5 class="mb-3"><i class="fas fa-info-circle"></i> Current Configuration Summary</h5>
    <div class="row">
        <div class="col-md-4">
            <div class="border rounded p-3 text-center">
                <h6 class="text-muted">AI Model</h6>
                <h5 class="text-primary">{{ $aiSettings->where('setting_key', 'ai_model')->first()->setting_value ?? $defaultAISettings['ai_model'] }}</h5>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded p-3 text-center">
                <h6 class="text-muted">Temperature</h6>
                <h5 class="text-success">{{ $aiSettings->where('setting_key', 'ai_temperature')->first()->setting_value ?? $defaultAISettings['ai_temperature'] }}</h5>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded p-3 text-center">
                <h6 class="text-muted">Max Tokens</h6>
                <h5 class="text-info">{{ $aiSettings->where('setting_key', 'ai_max_tokens')->first()->setting_value ?? $defaultAISettings['ai_max_tokens'] }}</h5>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function updateTemperatureValue(value) {
    document.getElementById('temperature_value').textContent = value;
}

function updateTokenValue(value) {
    document.getElementById('token_value').textContent = value;
}

// Initialize values on page load
document.addEventListener('DOMContentLoaded', function() {
    const tempSlider = document.getElementById('ai_temperature');
    const tokenSlider = document.getElementById('ai_max_tokens');
    
    updateTemperatureValue(tempSlider.value);
    updateTokenValue(tokenSlider.value);
});
</script>
@endsection

