<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Alternative OneSignal Test</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; }
        .status { padding: 10px; margin: 10px 0; border-radius: 5px; }
        .success { background: #d4edda; color: #155724; }
        .error { background: #f8d7da; color: #721c24; }
        .info { background: #d1ecf1; color: #0c5460; }
        button { padding: 10px 20px; margin: 5px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; }
        .code { background: #f8f9fa; padding: 10px; border-radius: 5px; font-family: monospace; margin: 10px 0; }
    </style>
</head>
<body>
    <h1>🔔 Alternative OneSignal Test</h1>
    
    <div id="status">Loading...</div>
    <div id="player-info" style="display: none;">
        <h3>Your Player ID:</h3>
        <div class="code" id="player-id"></div>
        <button onclick="requestPermission()">Request Permission</button>
    </div>

    <!-- Try different OneSignal SDK versions -->
    <script src="https://cdn.onesignal.com/sdks/OneSignalSDK.js"></script>
    <script>
        const appId = "{{ config('services.onesignal.app_id') }}";
        let playerId = null;
        
        function updateStatus(message, type = 'info') {
            document.getElementById('status').innerHTML = `<div class="status ${type}">${message}</div>`;
        }
        
        // Initialize OneSignal with the older SDK
        function initOneSignal() {
            updateStatus('🔄 Initializing OneSignal (Alternative SDK)...', 'info');
            
            try {
                // Check if OneSignal is available
                if (typeof OneSignal === 'undefined') {
                    updateStatus('❌ OneSignal SDK not loaded', 'error');
                    return;
                }
                
                console.log('OneSignal object:', OneSignal);
                
                // Initialize OneSignal
                OneSignal.init({
                    appId: appId,
                    allowLocalhostAsSecureOrigin: true,
                    subdomainName: "mewsai",
                    autoRegister: true,
                    notifyButton: {
                        enable: false
                    }
                });
                
                // Listen for initialization
                OneSignal.on('subscriptionChange', function(isSubscribed) {
                    console.log('Subscription changed:', isSubscribed);
                    if (isSubscribed) {
                        OneSignal.getUserId().then(function(userId) {
                            if (userId) {
                                playerId = userId;
                                document.getElementById('player-id').textContent = userId;
                                document.getElementById('player-info').style.display = 'block';
                                updateStatus('✅ OneSignal ready! Player ID: ' + userId, 'success');
                            }
                        });
                    }
                });
                
                // Check current state
                OneSignal.getUserId().then(function(userId) {
                    console.log('Current user ID:', userId);
                    if (userId) {
                        playerId = userId;
                        document.getElementById('player-id').textContent = userId;
                        document.getElementById('player-info').style.display = 'block';
                        updateStatus('✅ OneSignal ready! Player ID: ' + userId, 'success');
                    } else {
                        updateStatus('⚠️ OneSignal ready, but no player ID. Click "Request Permission"', 'info');
                        document.getElementById('player-info').style.display = 'block';
                    }
                });
                
                updateStatus('✅ OneSignal initialized successfully!', 'success');
                
            } catch (error) {
                console.error('OneSignal error:', error);
                updateStatus('❌ OneSignal failed: ' + error.message, 'error');
            }
        }
        
        function requestPermission() {
            try {
                OneSignal.showNativePrompt().then(function() {
                    updateStatus('✅ Permission granted!', 'success');
                    setTimeout(() => location.reload(), 1000);
                });
            } catch (error) {
                updateStatus('❌ Permission request failed: ' + error.message, 'error');
            }
        }
        
        // Start when page loads
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Page loaded, starting alternative OneSignal test...');
            setTimeout(initOneSignal, 1000);
        });
    </script>
</body>
</html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Alternative OneSignal Test</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; }
        .status { padding: 10px; margin: 10px 0; border-radius: 5px; }
        .success { background: #d4edda; color: #155724; }
        .error { background: #f8d7da; color: #721c24; }
        .info { background: #d1ecf1; color: #0c5460; }
        button { padding: 10px 20px; margin: 5px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; }
        .code { background: #f8f9fa; padding: 10px; border-radius: 5px; font-family: monospace; margin: 10px 0; }
    </style>
</head>
<body>
    <h1>🔔 Alternative OneSignal Test</h1>
    
    <div id="status">Loading...</div>
    <div id="player-info" style="display: none;">
        <h3>Your Player ID:</h3>
        <div class="code" id="player-id"></div>
        <button onclick="requestPermission()">Request Permission</button>
    </div>

    <!-- Try different OneSignal SDK versions -->
    <script src="https://cdn.onesignal.com/sdks/OneSignalSDK.js"></script>
    <script>
        const appId = "{{ config('services.onesignal.app_id') }}";
        let playerId = null;
        
        function updateStatus(message, type = 'info') {
            document.getElementById('status').innerHTML = `<div class="status ${type}">${message}</div>`;
        }
        
        // Initialize OneSignal with the older SDK
        function initOneSignal() {
            updateStatus('🔄 Initializing OneSignal (Alternative SDK)...', 'info');
            
            try {
                // Check if OneSignal is available
                if (typeof OneSignal === 'undefined') {
                    updateStatus('❌ OneSignal SDK not loaded', 'error');
                    return;
                }
                
                console.log('OneSignal object:', OneSignal);
                
                // Initialize OneSignal
                OneSignal.init({
                    appId: appId,
                    allowLocalhostAsSecureOrigin: true,
                    subdomainName: "mewsai",
                    autoRegister: true,
                    notifyButton: {
                        enable: false
                    }
                });
                
                // Listen for initialization
                OneSignal.on('subscriptionChange', function(isSubscribed) {
                    console.log('Subscription changed:', isSubscribed);
                    if (isSubscribed) {
                        OneSignal.getUserId().then(function(userId) {
                            if (userId) {
                                playerId = userId;
                                document.getElementById('player-id').textContent = userId;
                                document.getElementById('player-info').style.display = 'block';
                                updateStatus('✅ OneSignal ready! Player ID: ' + userId, 'success');
                            }
                        });
                    }
                });
                
                // Check current state
                OneSignal.getUserId().then(function(userId) {
                    console.log('Current user ID:', userId);
                    if (userId) {
                        playerId = userId;
                        document.getElementById('player-id').textContent = userId;
                        document.getElementById('player-info').style.display = 'block';
                        updateStatus('✅ OneSignal ready! Player ID: ' + userId, 'success');
                    } else {
                        updateStatus('⚠️ OneSignal ready, but no player ID. Click "Request Permission"', 'info');
                        document.getElementById('player-info').style.display = 'block';
                    }
                });
                
                updateStatus('✅ OneSignal initialized successfully!', 'success');
                
            } catch (error) {
                console.error('OneSignal error:', error);
                updateStatus('❌ OneSignal failed: ' + error.message, 'error');
            }
        }
        
        function requestPermission() {
            try {
                OneSignal.showNativePrompt().then(function() {
                    updateStatus('✅ Permission granted!', 'success');
                    setTimeout(() => location.reload(), 1000);
                });
            } catch (error) {
                updateStatus('❌ Permission request failed: ' + error.message, 'error');
            }
        }
        
        // Start when page loads
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Page loaded, starting alternative OneSignal test...');
            setTimeout(initOneSignal, 1000);
        });
    </script>
</body>
</html>
