<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Login - Mews AI</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #0a57d4;
            --secondary-color: #2d72f0;
            --accent-color: #5a95ff;
            --bg-primary: #1a1a1a;
            --bg-secondary: #2d2d2d;
            --text-primary: #ffffff;
            --text-secondary: #b3b3b3;
            --border-color: #404040;
            --card-shadow: 0 8px 32px rgba(255, 107, 53, 0.15);
            --card-shadow-hover: 0 12px 40px rgba(255, 107, 53, 0.25);
        }
        
        [data-theme="light"] {
            --bg-primary: #ffffff;
            --bg-secondary: #f8f9fa;
            --text-primary: #333333;
            --text-secondary: #666666;
            --border-color: #dee2e6;
            --card-shadow: 0 8px 32px rgba(255, 107, 53, 0.1);
            --card-shadow-hover: 0 12px 40px rgba(255, 107, 53, 0.2);
        }

        body {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: var(--text-primary);
            transition: all 0.3s ease;
        }

        .login-container {
            background: var(--bg-primary);
            border: 1px solid var(--border-color);
            border-radius: 20px;
            box-shadow: var(--card-shadow);
            padding: 40px;
            width: 100%;
            max-width: 400px;
            transition: all 0.3s ease;
        }

        .login-header {
            text-align: center;
            margin-bottom: 30px;
        }

        .login-header h1 {
            color: var(--primary-color);
            font-weight: bold;
            margin-bottom: 10px;
        }

        .login-header p {
            color: var(--text-secondary);
            margin: 0;
        }

        .form-control {
            background: var(--bg-secondary);
            border: 2px solid var(--border-color);
            border-radius: 10px;
            padding: 12px 15px;
            color: var(--text-primary);
            transition: all 0.3s ease;
        }

        .form-control:focus {
            background: var(--bg-secondary);
            border-color: var(--primary-color);
            color: var(--text-primary);
            box-shadow: 0 0 0 0.2rem rgba(255, 107, 53, 0.25);
        }
        
        .form-control::placeholder {
            color: var(--text-secondary);
        }

        .form-label {
            color: var(--text-primary);
            font-weight: 600;
            margin-bottom: 8px;
            display: block;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            border: none;
            border-radius: 10px;
            padding: 12px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(255, 107, 53, 0.4);
        }

        .form-check-input:checked {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        .register-link {
            text-align: center;
            margin-top: 20px;
        }

        .register-link a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 600;
        }

        .register-link a:hover {
            text-decoration: underline;
        }
        
        /* Loading Indicators */
        .loading-spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
            margin-right: 8px;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        .btn-loading {
            opacity: 0.7;
            pointer-events: none;
            position: relative;
        }
        
        .btn-loading::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 16px;
            height: 16px;
            margin: -8px 0 0 -8px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
        }
        
        .btn-loading .btn-text {
            opacity: 0;
        }
        
        /* Subtle loading overlay */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(2px);
            z-index: 9999;
            display: none;
            align-items: center;
            justify-content: center;
        }
        
        .loading-overlay.show {
            display: flex;
        }
        
        .loading-content {
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            box-shadow: var(--card-shadow);
        }
        
        .loading-content .loading-spinner {
            width: 24px;
            height: 24px;
            margin: 0 0 12px 0;
        }
        
        .loading-content .loading-text {
            color: var(--text-primary);
            font-size: 14px;
            font-weight: 500;
        }

        .back-to-home {
            position: absolute;
            top: 20px;
            left: 20px;
            color: white;
            text-decoration: none;
            font-weight: 600;
        }

        .back-to-home:hover {
            color: white;
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <a href="{{ route('news.chatbot') }}" class="back-to-home">
        <i class="fas fa-arrow-left"></i> Back to Mews AI
    </a>

    <div class="login-container">
        <div class="login-header">
            <h1><i class="fas fa-robot"></i> Welcome Back</h1>
            <p>Sign in to your Mews AI account</p>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ route('login') }}">
            @csrf
            
            <div class="mb-3">
                <label for="email" class="form-label">Email Address</label>
                <input type="email" class="form-control @error('email') is-invalid @enderror" 
                       id="email" name="email" value="{{ old('email') }}" required autofocus>
                @error('email')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" class="form-control @error('password') is-invalid @enderror" 
                       id="password" name="password" required>
                @error('password')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3 form-check">
                <input type="checkbox" class="form-check-input" id="remember" name="remember">
                <label class="form-check-label" for="remember">
                    Remember me
                </label>
            </div>

            <button type="submit" class="btn btn-primary w-100" id="loginBtn">
                <span class="btn-text">
                    <i class="fas fa-sign-in-alt"></i> Sign In
                </span>
            </button>
        </form>

        <div class="register-link">
            <p>Don't have an account? <a href="{{ route('register') }}">Create one here</a></p>
    </div>
</div>

<!-- Loading Overlay -->
<div id="loadingOverlay" class="loading-overlay">
    <div class="loading-content">
        <div class="loading-spinner"></div>
        <div class="loading-text" id="loadingText">Loading...</div>
    </div>
</div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- CSRF Token Refresh Script -->
    <script>
        // Refresh CSRF token on page load to prevent 419 errors
        document.addEventListener('DOMContentLoaded', function() {
            // Get fresh CSRF token
            fetch('{{ route("login") }}', {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.text())
            .then(html => {
                // Extract new CSRF token from response
                const parser = new DOMParser();
                const doc = parser.parseFromString(html, 'text/html');
                const newToken = doc.querySelector('meta[name="csrf-token"]');
                
                if (newToken) {
                    // Update the CSRF token in the form
                    const formToken = document.querySelector('input[name="_token"]');
                    if (formToken) {
                        formToken.value = newToken.getAttribute('content');
                    }
                    
                    // Update meta tag
                    const metaToken = document.querySelector('meta[name="csrf-token"]');
                    if (metaToken) {
                        metaToken.setAttribute('content', newToken.getAttribute('content'));
                    }
                }
            })
            .catch(error => {
                console.log('CSRF token refresh failed:', error);
            });
        });
        
        // Loading indicator functions
        function showLoading(message = 'Loading...') {
            const overlay = document.getElementById('loadingOverlay');
            const text = document.getElementById('loadingText');
            text.textContent = message;
            overlay.classList.add('show');
        }
        
        function hideLoading() {
            const overlay = document.getElementById('loadingOverlay');
            overlay.classList.remove('show');
        }
        
        function setButtonLoading(button, loading = true) {
            if (loading) {
                button.classList.add('btn-loading');
                button.disabled = true;
                const text = button.querySelector('.btn-text');
                if (text) {
                    text.style.opacity = '0';
                }
            } else {
                button.classList.remove('btn-loading');
                button.disabled = false;
                const text = button.querySelector('.btn-text');
                if (text) {
                    text.style.opacity = '1';
                }
            }
        }

        // Theme Management
        document.addEventListener('DOMContentLoaded', function() {
            // Theme management is now handled by the centralized ThemeManager
            // Just ensure the theme is applied to the body element
            const savedTheme = localStorage.getItem('theme');
            if (savedTheme === 'dark') {
                document.body.setAttribute('data-theme', 'dark');
            } else {
                // Default to light mode if no theme is saved
                document.body.removeAttribute('data-theme');
            }
            
            // Handle login form submission
            const loginForm = document.querySelector('form');
            const loginBtn = document.getElementById('loginBtn');
            
            if (loginForm && loginBtn) {
                loginForm.addEventListener('submit', function(e) {
                    // Show loading state
                    setButtonLoading(loginBtn, true);
                    showLoading('Signing in...');
                    
                    // The form will submit normally, but we show loading feedback
                });
            }
        });
    </script>
</body>
</html>

