<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Deep Dive - {{ $article['title'] }}</title>
    
    <!-- Open Graph Meta Tags for Social Media Sharing -->
    <meta property="og:title" content="Deep Dive - {{ $article['title'] }}">
    <meta property="og:description" content="{{ Str::limit($article['content'] ?? 'AI-powered news analysis and insights', 160) }}">
    <meta property="og:image" content="{{ asset('assets/images/mews.png') }}">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="Mews AI - Deep Dive Analysis">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:type" content="article">
    <meta property="og:site_name" content="Mews AI">
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Deep Dive - {{ $article['title'] }}">
    <meta name="twitter:description" content="{{ Str::limit($article['content'] ?? 'AI-powered news analysis and insights', 160) }}">
    <meta name="twitter:image" content="{{ asset('assets/images/mews.png') }}">
    <meta name="twitter:image:alt" content="Mews AI - Deep Dive Analysis">
    
    <!-- Additional Meta Tags -->
    <meta name="description" content="{{ Str::limit($article['content'] ?? 'AI-powered news analysis and insights', 160) }}">
    <meta name="keywords" content="news, AI, analysis, deep dive, {{ $article['category'] ?? 'news' }}">
    
    <!-- PWA Meta Tags -->
    <meta name="application-name" content="Mews">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Mews">
    <meta name="description" content="AI-powered news chatbot for personalized news discovery">
    <meta name="format-detection" content="telephone=no">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="msapplication-config" content="{{ asset('browserconfig.xml') }}">
    <meta name="msapplication-TileColor" content="#0a57d4">
    <meta name="msapplication-tap-highlight" content="no">
    <meta name="theme-color" content="#0a57d4">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="{{ asset('manifest.json') }}">
    
    <!-- Apple Touch Icons -->
    <link rel="apple-touch-icon" href="{{ asset('assets/images/logo/apple-touch-icon-180x180.png') }}">
    <link rel="apple-touch-icon" sizes="152x152" href="{{ asset('assets/images/logo/apple-touch-icon-152x152.png') }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('assets/images/logo/apple-touch-icon-180x180.png') }}">
    <link rel="apple-touch-icon" sizes="167x167" href="{{ asset('assets/images/logo/apple-touch-icon-167x167.png') }}">
    
    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('assets/images/logo/favicon.png') }}">
    <style>
        :root {
            --primary-orange: #0a57d4;
            --secondary-orange: #2d72f0;
            --accent-orange: #5a95ff;
            --dark-bg: #1a1a1a;
            --light-bg: #ffffff;
            --dark-text: #ffffff;
            --light-text: #333333;
            --card-bg: #2a2a2a;
            --light-card-bg: #f8f9fa;
            --border-color: #404040;
            --light-border-color: #e9ecef;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            /* background: linear-gradient(135deg, #0a57d4 0%, #2d72f0 100%); */
            background: #f3f7fe   /* soft blue-white */;
            min-height: 100vh;
            height: 100vh;
            transition: all 0.3s ease;
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }

        body.dark-mode {
            background: linear-gradient(135deg, #0a57d4, #2d72f0);
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            flex: 1;
            overflow-y: auto;
            padding-bottom: 20px;
        }

        /* Article Title Container with Back Arrow */
        .article-title-container {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 15px;
        }

        .back-arrow-btn {
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.9);
            border: 2px solid rgba(255, 107, 53, 0.3);
            color: #000000;
            padding: 10px;
            border-radius: 50%;
            cursor: pointer;
            transition: all 0.3s ease;
            backdrop-filter: blur(10px);
            width: 40px;
            height: 40px;
            flex-shrink: 0;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .back-arrow-btn:hover {
            background: rgba(255, 107, 53, 0.1);
            border-color: #0a57d4;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(10, 87, 212, 0.3);
            color: #000000;
        }

        .back-arrow-btn i {
            width: 18px;
            height: 18px;
        }

        .dark-mode .back-arrow-btn {
            background: rgba(255, 255, 255, 0.15);
            border: 2px solid rgba(255, 107, 53, 0.4);
            color: #000000;
        }

        .dark-mode .back-arrow-btn:hover {
            background: rgba(255, 107, 53, 0.2);
            border-color: #0a57d4;
            color: #000000;
        }

        .article-section {
            background: var(--light-card-bg);
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--light-border-color);
        }

        .dark-mode .article-section {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
        }

        .article-header {
            margin-bottom: 25px;
        }

        .article-title {
            font-size: clamp(1.5rem, 4vw, 2.5rem);
            color: var(--light-text);
            margin-bottom: 15px;
            line-height: 1.3;
        }

        .dark-mode .article-title {
            color: var(--dark-text);
        }

        .article-meta {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
            margin-bottom: 20px;
        }

        .meta-item {
            background: rgba(10, 87, 212, 0.2)   /* based on #0a57d4 */;
            color: #0a57d4;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 0.9rem;
            font-weight: 500;
        }

        .article-content {
            color: var(--light-text);
            line-height: 1.8;
            font-size: 1.1rem;
        }
        
        /* Ensure HTML content renders properly */
        .article-content div,
        .article-content p,
        .article-content h1,
        .article-content h2,
        .article-content h3,
        .article-content h4,
        .article-content h5,
        .article-content h6 {
            margin-bottom: 1rem;
        }
        
        .article-content div:last-child,
        .article-content p:last-child,
        .article-content h1:last-child,
        .article-content h2:last-child,
        .article-content h3:last-child,
        .article-content h4:last-child,
        .article-content h5:last-child,
        .article-content h6:last-child {
            margin-bottom: 0;
        }
        
        .article-content img {
            max-width: 100%;
            height: auto;
            border-radius: 10px;
            margin: 1rem 0;
        }
        
        .article-content video {
            max-width: 100%;
            height: auto;
            border-radius: 10px;
            margin: 1rem 0;
        }
        
        .article-content iframe {
            max-width: 100%;
            border-radius: 10px;
            margin: 1rem 0;
        }
        
        .article-content figure {
            margin: 1rem 0;
            text-align: center;
        }
        
        .article-content figcaption {
            font-size: 0.9rem;
            color: rgba(0, 0, 0, 0.6);
            margin-top: 0.5rem;
            font-style: italic;
        }
        
        .dark-mode .article-content figcaption {
            color: rgba(255, 255, 255, 0.7);
        }
        
        .article-content blockquote {
            border-left: 4px solid #0a57d4;
            padding-left: 1rem;
            margin: 1rem 0;
            font-style: italic;
            background: rgba(255, 107, 53, 0.1);
            padding: 1rem;
            border-radius: 0 10px 10px 0;
        }
        
        .article-content ul,
        .article-content ol {
            margin: 1rem 0;
            padding-left: 2rem;
        }
        
        .article-content li {
            margin-bottom: 0.5rem;
        }

        .dark-mode .article-content {
            color: var(--dark-text);
        }

        .chat-section {
            background: var(--light-card-bg);
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--light-border-color);
        }

        .dark-mode .chat-section {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
        }

        .chat-header {
            text-align: center;
            margin-bottom: 25px;
        }

        .chat-title {
            font-size: clamp(1.3rem, 3vw, 2rem);
            color: var(--light-text);
            margin-bottom: 10px;
        }

        .dark-mode .chat-title {
            color: var(--dark-text);
        }

        .chat-subtitle {
            color: rgba(0, 0, 0, 0.6);
            font-size: 1rem;
        }

        .dark-mode .chat-subtitle {
            color: rgba(255, 255, 255, 0.7);
        }

        .chat-box-list {
            max-height: 400px;
            overflow-y: auto;
            margin-bottom: 20px;
            padding: 20px;
            background: rgba(0, 0, 0, 0.05);
            border-radius: 15px;
            border: 1px solid rgba(0, 0, 0, 0.1);
        }

        .dark-mode .chat-box-list {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .chat-message {
            margin-bottom: 20px;
            padding: 15px 20px;
            border-radius: 15px;
            max-width: 80%;
            word-wrap: break-word;
        }
        
        .typing-cursor {
            color: #0a57d4;
            font-weight: bold;
            animation: blink 1s infinite;
        }
        
        @keyframes blink {
            0%, 50% { opacity: 1; }
            51%, 100% { opacity: 0; }
        }

        .user-message {
            background: linear-gradient(135deg, #0a57d4, #2d72f0);
            color: white;
            margin-left: auto;
            text-align: right;
        }

        .bot-message {
            background: rgba(0, 0, 0, 0.05);
            color: var(--light-text);
            border: 1px solid rgba(0, 0, 0, 0.1);
        }

        .dark-mode .bot-message {
            background: rgba(255, 255, 255, 0.1);
            color: var(--dark-text);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .dark-mode .typing-cursor {
            color: #0a57d4;
        }

        .chat-input-container {
            position: relative;
            background: var(--light-card-bg);
            border-top: 1px solid var(--light-border-color);
            padding: 15px 20px;
            display: flex;
            gap: 15px;
            align-items: flex-end;
            z-index: 1000;
            backdrop-filter: blur(10px);
            width: 100%;
            flex-shrink: 0;
        }

        .dark-mode .chat-input-container {
            background: var(--card-bg);
            border-top: 1px solid var(--border-color);
        }

        .chat-input {
            width: 100%;
            background: rgba(0, 0, 0, 0.05);
            border: 2px solid rgba(0, 0, 0, 0.1);
            border-radius: 25px;
            padding: 15px 20px;
            color: var(--light-text);
            font-size: 1rem;
            resize: none;
            min-height: 50px;
            max-height: 120px;
            transition: all 0.3s ease;
        }

        .dark-mode .chat-input {
            background: rgba(255, 255, 255, 0.1);
            border: 2px solid rgba(255, 255, 255, 0.2);
            color: var(--dark-text);
        }

        .chat-input:focus {
            outline: none;
            border-color: #0a57d4;
            background: rgba(0, 0, 0, 0.08);
        }

        .dark-mode .chat-input:focus {
            background: rgba(255, 255, 255, 0.15);
        }

        .chat-input::placeholder {
            color: rgba(0, 0, 0, 0.5);
        }

        .dark-mode .chat-input::placeholder {
            color: rgba(255, 255, 255, 0.6);
        }

        .send-button {
            background: linear-gradient(135deg, #0a57d4, #2d72f0);
            border: none;
            color: white;
            padding: 15px 25px;
            border-radius: 25px;
            cursor: pointer;
            font-weight: 600;
            transition: all 0.3s ease;
            min-width: 80px;
        }

        .send-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(10, 87, 212, 0.4);
        }

        .send-button:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }

        .loading {
            display: none;
            text-align: center;
            color: #0a57d4;
            font-style: italic;
        }
        
        .thinking-indicator {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 4px;
            margin: 20px 0;
        }
        
        .thinking-dot {
            width: 8px;
            height: 8px;
            background: #0a57d4;
            border-radius: 50%;
            animation: thinking 1.4s infinite ease-in-out;
        }
        
        .thinking-dot:nth-child(1) { animation-delay: -0.32s; }
        .thinking-dot:nth-child(2) { animation-delay: -0.16s; }
        
        @keyframes thinking {
            0%, 80%, 100% {
                transform: scale(0.8);
                opacity: 0.5;
            }
            40% {
                transform: scale(1);
                opacity: 1;
            }
        }
        
        
        

        @media (max-width: 768px) {
            .container {
                padding: 15px;
                padding-bottom: 20px;
                max-width: 100%;
            }
            
            .article-title-container {
                gap: 12px;
                margin-bottom: 12px;
            }
            
            .back-arrow-btn {
                width: 36px;
                height: 36px;
                padding: 8px;
            }
            
            .back-arrow-btn i {
                width: 16px;
                height: 16px;
            }
            
            .back-button-container {
                margin-bottom: 15px;
            }
            
            .back-button {
                padding: 10px 16px;
                font-size: 0.9rem;
                border-radius: 20px;
            }
            
            .back-button i {
                width: 16px;
                height: 16px;
            }
            
            .article-section,
            .chat-section {
                padding: 20px;
                margin-bottom: 20px;
                border-radius: 15px;
            }
            
            .article-title {
                font-size: clamp(1.3rem, 5vw, 2rem);
                line-height: 1.2;
            }
            
            .article-meta {
                gap: 8px;
                flex-direction: column;
                align-items: stretch;
            }
            
            .meta-item {
                padding: 10px 15px;
                font-size: 0.9rem;
                text-align: center;
                border-radius: 15px;
            }
            
            .article-content {
                font-size: 1rem;
                line-height: 1.6;
            }
            
            .article-content div,
            .article-content p,
            .article-content h1,
            .article-content h2,
            .article-content h3,
            .article-content h4,
            .article-content h5,
            .article-content h6 {
                margin-bottom: 0.8rem;
            }
            
            .article-content img {
                margin: 0.8rem 0;
                border-radius: 8px;
            }
            
            .article-content blockquote {
                margin: 0.8rem 0;
                padding: 0.8rem;
                border-radius: 8px;
            }
            
            .article-content ul,
            .article-content ol {
                margin: 0.8rem 0;
                padding-left: 1.5rem;
            }
            
            .chat-header {
                margin-bottom: 20px;
            }
            
            .chat-title {
                font-size: clamp(1.2rem, 4vw, 1.8rem);
            }
            
            .chat-subtitle {
                font-size: 0.9rem;
            }
            
            .chat-box-list {
                max-height: 300px;
                padding: 15px;
                margin-bottom: 15px;
            }
            
            .chat-message {
                max-width: 90%;
                padding: 12px 16px;
                margin-bottom: 15px;
                font-size: 0.95rem;
            }
            
            .chat-input-container {
                flex-direction: column;
                gap: 12px;
                width: 100%;
            }
            
            .chat-input {
                width: 100%;
                min-height: 60px;
                padding: 15px 18px;
                font-size: 1rem;
                border-radius: 20px;
            }
            
            .send-button {
                width: 100%;
                padding: 18px 25px;
                font-size: 1rem;
                border-radius: 20px;
            }
            
            .loading {
                font-size: 0.9rem;
                padding: 10px;
            }
        }
        
        @media (max-width: 480px) {
            .container {
                padding: 10px;
                padding-bottom: 15px;
            }
            
            .article-title-container {
                gap: 10px;
                margin-bottom: 10px;
            }
            
            .back-arrow-btn {
                width: 32px;
                height: 32px;
                padding: 6px;
            }
            
            .back-arrow-btn i {
                width: 14px;
                height: 14px;
            }
            
            .back-button-container {
                margin-bottom: 12px;
            }
            
            .back-button {
                padding: 8px 14px;
                font-size: 0.85rem;
                border-radius: 18px;
            }
            
            .back-button i {
                width: 14px;
                height: 14px;
            }
            
            .article-section,
            .chat-section {
                padding: 15px;
                border-radius: 12px;
            }
            
            .article-title {
                font-size: clamp(1.2rem, 6vw, 1.8rem);
            }
            
            .article-meta {
                gap: 6px;
            }
            
            .meta-item {
                padding: 8px 12px;
                font-size: 0.8rem;
                border-radius: 12px;
            }
            
            .article-content {
                font-size: 0.95rem;
                line-height: 1.5;
            }
            
            .chat-title {
                font-size: clamp(1.1rem, 5vw, 1.6rem);
            }
            
            .chat-box-list {
                max-height: 250px;
                padding: 12px;
            }
            
            .chat-message {
                padding: 10px 14px;
                font-size: 0.9rem;
                border-radius: 12px;
            }
            
            .chat-input {
                width: 100%;
                min-height: 55px;
                padding: 12px 16px;
                font-size: 0.95rem;
            }
            
            .send-button {
                padding: 15px 20px;
                font-size: 0.95rem;
            }
        }
        
        /* Mobile-specific touch improvements */
        @media (max-width: 768px) {
            .send-button {
                -webkit-tap-highlight-color: transparent;
                touch-action: manipulation;
            }
            
            .send-button:active {
                transform: scale(0.98);
            }
            
            .chat-input:focus {
                font-size: 16px; /* Prevents zoom on iOS */
            }
            
            .chat-input-container {
                padding: 12px 15px;
            }
            
            .chat-input {
                min-height: 55px;
                padding: 12px 18px;
            }
            
            .send-button {
                padding: 12px 20px;
                min-width: 70px;
            }
        }

        /* Custom scrollbar */
        .chat-box-list::-webkit-scrollbar {
            width: 8px;
        }

        .chat-box-list::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 4px;
        }

        .chat-box-list::-webkit-scrollbar-thumb {
            background: #0a57d4;
            border-radius: 4px;
        }

        .chat-box-list::-webkit-scrollbar-thumb:hover {
            background: var(--secondary-orange);
        }

        /* Play Video Button Styles */
        .play-video-btn {
            background: linear-gradient(135deg, #0a57d4, #147EF3) !important;
            color: white !important;
            border: none !important;
            padding: 12px 24px !important;
            border-radius: 25px !important;
            cursor: pointer !important;
            font-weight: 500 !important;
            margin: 1rem 0 !important;
            display: inline-flex !important;
            align-items: center !important;
            gap: 8px !important;
            box-shadow: 0 4px 15px rgba(10, 87, 212, 0.3) !important;
            transition: all 0.3s ease !important;
            font-size: 0.95rem !important;
        }

        .play-video-btn:hover {
            transform: translateY(-2px) !important;
            box-shadow: 0 6px 20px rgba(10, 87, 212, 0.4) !important;
            background: linear-gradient(135deg, #0a57d4, #2d72f0) !important;
        }

        .play-video-btn i {
            width: 16px !important;
            height: 16px !important;
        }
    </style>
    
    <!-- Theme Manager -->
    <script src="{{ asset('js/theme-manager.js') }}"></script>
    <!-- Feather Icons -->
    <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>
    
    <!-- Immediate theme application to prevent flash -->
    <script>
        (function() {
            const savedTheme = localStorage.getItem('theme');
            // Default to light mode if no theme is saved
            if (savedTheme === 'dark') {
                document.body.classList.add('dark-mode');
            } else {
                // Default to light mode
                document.body.classList.remove('dark-mode');
                localStorage.setItem('theme', 'light');
            }
        })();
    </script>
</head>
<body>
    <div class="container">
        <!-- Article Section -->
        <div class="article-section">
            <div class="article-header">
                <div class="article-title-container">
                    <!-- <button class="back-arrow-btn" onclick="goBackToChatbot()" aria-label="Back to chatbot">
                        <i class="feather" data-feather="arrow-left"></i>
                    </button> -->
                    <h1 class="article-title">{{ $article['title'] }}</h1>
                </div>
                <div class="article-meta">
                    <!-- <span class="meta-item">{{ $article['category'] }}</span>
                    @if($article['sub_category'])
                        <span class="meta-item">{{ $article['sub_category'] }}</span>
                    @endif -->
                    <span class="meta-item">{{ $article['date'] }}</span>
                </div>
            </div>
            <div class="article-content">
                {!! $article['content'] !!}
            </div>
        </div>

        <!-- Chat Section -->
        <div class="chat-section">
            <div class="chat-header">
                <h2 class="chat-title">Ask Questions About This Article</h2>
                <p class="chat-subtitle">Get deeper insights and analysis from Mews</p>
            </div>
            
            <div class="chat-box-list" id="chatBoxList" style="display: none;">
                <!-- Chat messages will appear here -->
            </div>
            
            <div class="chat-input-container">
                <textarea 
                    class="chat-input" 
                    id="chatInput" 
                    placeholder="Ask a question about this article..."
                    rows="1"
                ></textarea>
                <button class="send-button" id="sendButton" onclick="sendMessage()">
                    Send
                </button>
            </div>
            
            <div class="loading" id="loading"></div>
        </div>
    </div>

    <script>
        // Theme management removed - using persistent theme from chatbot
        
        // Load saved theme
        document.addEventListener('DOMContentLoaded', function() {
            // Theme is already applied via the immediate script in head
            // Page loaded - no auto-scroll
            
            // Initialize feather icons
            feather.replace();
            
            // Ensure back arrow button icon is properly initialized
            const backArrowBtn = document.querySelector('.back-arrow-btn i');
            if (backArrowBtn) {
                backArrowBtn.setAttribute('data-feather', 'arrow-left');
                feather.replace();
            }
        });

        // Back button functionality
        function goBackToChatbot() {
            // Use history.back() to maintain chat history
            // This will return to the chatbot page with all previous chats intact
            if (window.history.length > 1) {
                window.history.back();
            } else {
                // Fallback to direct navigation if no history
                window.location.href = '{{ route("news.chatbot") }}';
            }
        }

        // Play Video Button Handler
        function playVideo(button) {
            // Find the closest video element or iframe
            let videoElement = button.parentElement.querySelector('video');
            let iframeElement = button.parentElement.querySelector('iframe');
            
            if (videoElement) {
                // Handle HTML5 video
                if (videoElement.paused) {
                    videoElement.play();
                    button.innerHTML = '<i class="feather" data-feather="pause" style="width: 16px; height: 16px;"></i> Pause Video';
                } else {
                    videoElement.pause();
                    button.innerHTML = '<i class="feather" data-feather="play" style="width: 16px; height: 16px;"></i> Play Video';
                }
                feather.replace(); // Re-initialize feather icons
            } else if (iframeElement) {
                // Handle embedded videos (YouTube, Vimeo, etc.)
                // For embedded videos, we can't control playback directly
                // So we'll just scroll to the video
                iframeElement.scrollIntoView({ behavior: 'smooth', block: 'center' });
                button.innerHTML = '<i class="feather" data-feather="external-link" style="width: 16px; height: 16px;"></i> View Video';
                feather.replace(); // Re-initialize feather icons
            } else {
                // If no video found, show a message
                button.innerHTML = '<i class="feather" data-feather="alert-circle" style="width: 16px; height: 16px;"></i> Video Not Found';
                feather.replace(); // Re-initialize feather icons
            }
        }

        // Chat functionality
        let isProcessing = false;

        function sendMessage() {
            if (isProcessing) return;
            
            const input = document.getElementById('chatInput');
            const message = input.value.trim();
            
            if (!message) return;
            
            // Show chat box on first message
            const chatBoxList = document.getElementById('chatBoxList');
            if (chatBoxList.style.display === 'none') {
                chatBoxList.style.display = 'block';
            }
            
            // Add user message to chat
            addMessage(message, 'user');
            input.value = '';
            
            // Show loading
            showLoading(true);
            isProcessing = true;
            
            // Send to backend
            fetch(`{{ route('news.deep-dive.chat', $article['id']) }}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({ message: message })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Hide loading before starting typing effect
                    showLoading(false);
                    addMessage(data.response, 'bot');
                } else {
                    showLoading(false);
                    addMessage('Sorry, I encountered an error. Please try again.', 'bot');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showLoading(false);
                addMessage('Sorry, I encountered an error. Please try again.', 'bot');
            })
            .finally(() => {
                isProcessing = false;
            });
        }

        function addMessage(text, sender) {
            const chatBoxList = document.getElementById('chatBoxList');
            const messageDiv = document.createElement('div');
            messageDiv.className = `chat-message ${sender}-message`;
            
            if (sender === 'bot') {
                // For AI messages, add typing effect
                messageDiv.innerHTML = '<span class="typing-cursor">|</span>';
                chatBoxList.appendChild(messageDiv);
                
                // Start typing effect
                typeMessage(messageDiv, text);
            } else {
                // For user messages, show immediately
                messageDiv.textContent = text;
                chatBoxList.appendChild(messageDiv);
            }
            
            // Message added - no auto-scroll
        }
        
        function typeMessage(messageDiv, text) {
            let index = 0;
            // Get typing speed from settings
            const typingSpeedSetting = '{{ $uiSettings["typing_speed"] ?? "medium" }}';
            let typingSpeed;
            switch(typingSpeedSetting) {
                case 'slow': typingSpeed = 50; break;
                case 'fast': typingSpeed = 15; break;
                case 'instant': typingSpeed = 0; break;
                case 'medium':
                default: typingSpeed = 30; break;
            }
            
            function typeNextChar() {
                if (index < text.length) {
                    // Remove the cursor and add the next character
                    messageDiv.innerHTML = text.substring(0, index + 1) + '<span class="typing-cursor">|</span>';
                    index++;
                    
                    // Continue typing (skip animation if instant)
                    if (typingSpeed > 0) {
                        setTimeout(typeNextChar, typingSpeed);
                    } else {
                        // For instant, show all text immediately
                        index = text.length;
                        typeNextChar();
                    }
                } else {
                    // Remove the cursor when typing is complete
                    messageDiv.innerHTML = text;
                }
                
                // Typing in progress - no auto-scroll
            }
            
            // Start typing
            typeNextChar();
        }
        
        function scrollToLatestMessage() {
            const chatBoxList = document.getElementById('chatBoxList');
            const chatSection = document.querySelector('.chat-section');
            
            // Scroll the chat box to the bottom
            chatBoxList.scrollTop = chatBoxList.scrollHeight;
            
            // Scroll the entire page to show the chat section
            chatSection.scrollIntoView({ 
                behavior: 'smooth', 
                block: 'end',
                inline: 'nearest'
            });
        }

        
        function showLoading(show) {
            const loading = document.getElementById('loading');
            const sendButton = document.getElementById('sendButton');

            if (show) {
                // Show thinking indicator
                loading.innerHTML = `
                    <div class="thinking-indicator">
                        <div class="thinking-dot"></div>
                        <div class="thinking-dot"></div>
                        <div class="thinking-dot"></div>
                    </div>
                `;
                loading.style.display = 'block';
                sendButton.disabled = true;
                
            } else {
                loading.style.display = 'none';
                sendButton.disabled = false;
            }
        }

        // Enter key to send
        document.getElementById('chatInput').addEventListener('keydown', function(e) {
            if (e.key === 'Enter' && !e.shiftKey) {
                e.preventDefault();
                sendMessage();
            }
        });

        // Auto-resize textarea
        document.getElementById('chatInput').addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = Math.min(this.scrollHeight, 120) + 'px';
        });
        
        // Mobile-specific improvements
        document.addEventListener('DOMContentLoaded', function() {
            // Prevent double-tap zoom on mobile
            let lastTouchEnd = 0;
            document.addEventListener('touchend', function(event) {
                const now = (new Date()).getTime();
                if (now - lastTouchEnd <= 300) {
                    event.preventDefault();
                }
                lastTouchEnd = now;
            }, false);
            
            // Improve mobile scrolling
            const chatBoxList = document.getElementById('chatBoxList');
            if (chatBoxList) {
                chatBoxList.style.webkitOverflowScrolling = 'touch';
            }
            
            // Mobile-friendly input handling
            const chatInput = document.getElementById('chatInput');
            if (chatInput) {
                // Prevent zoom on iOS when focusing input
                chatInput.addEventListener('focus', function() {
                    if (window.innerWidth <= 768) {
                        this.style.fontSize = '16px';
                    }
                });
                
                chatInput.addEventListener('blur', function() {
                    if (window.innerWidth <= 768) {
                        this.style.fontSize = '';
                    }
                });
            }
        });
        
        // PWA Service Worker Registration
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('{{ asset("sw.js") }}')
                    .then(function(registration) {
                        console.log('ServiceWorker registration successful');
                    })
                    .catch(function(err) {
                        console.log('ServiceWorker registration failed: ', err);
                    });
            });
        }
    </script>
</body>
</html>
