<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- PWA Meta Tags -->
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="Mews AI">
    <meta name="theme-color" content="#0a57d4">
    <meta name="msapplication-TileColor" content="#0a57d4">
    <meta name="msapplication-config" content="/browserconfig.xml">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="/manifest.json">
    
    <!-- Apple Touch Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="/assets/images/icon-180x180.png">
    <link rel="apple-touch-icon" sizes="152x152" href="/assets/images/icon-152x152.png">
    <link rel="apple-touch-icon" sizes="144x144" href="/assets/images/icon-144x144.png">
    <link rel="apple-touch-icon" sizes="120x120" href="/assets/images/icon-120x120.png">
    <link rel="apple-touch-icon" sizes="114x114" href="/assets/images/icon-114x114.png">
    <link rel="apple-touch-icon" sizes="76x76" href="/assets/images/icon-76x76.png">
    <link rel="apple-touch-icon" sizes="72x72" href="/assets/images/icon-72x72.png">
    <link rel="apple-touch-icon" sizes="60x60" href="/assets/images/icon-60x60.png">
    <link rel="apple-touch-icon" sizes="57x57" href="/assets/images/icon-57x57.png">
    
    <!-- Standard Icons -->
    <link rel="icon" type="image/png" sizes="32x32" href="/assets/images/icon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/assets/images/icon-16x16.png">
    <link rel="shortcut icon" href="/favicon.ico">

    <title>@yield('title', 'Mews AI News Chatbot')</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root {
            --bg-primary: #ffffff;
            --bg-secondary: #f8f9fa;
            --text-primary: #333333;
            --text-secondary: #666666;
            --accent-color: #0a57d4;
            --accent-gradient: linear-gradient(135deg, #0a57d4 0%, #2d72f0 100%);
            --accent-hover: linear-gradient(135deg, #083a8f 0%, #1e4a9a 100%);
            --border-color: #dee2e6;
            --card-shadow: 0 8px 32px rgba(255, 107, 53, 0.1);
            --card-shadow-hover: 0 12px 40px rgba(255, 107, 53, 0.2);
        }
        
        [data-theme="dark"] {
            --bg-primary: #1a1a1a;
            --bg-secondary: #2d2d2d;
            --text-primary: #ffffff;
            --text-secondary: #b3b3b3;
            --border-color: #404040;
            --card-shadow: 0 8px 32px rgba(255, 107, 53, 0.15);
            --card-shadow-hover: 0 12px 40px rgba(255, 107, 53, 0.25);
        }
        
        * {
            box-sizing: border-box;
        }
        
        body {
            background-color: var(--bg-primary);
            color: var(--text-primary);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            transition: all 0.3s ease;
            overflow-x: hidden;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }
        
        /* App-like feel */
        .app-container {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        .app-content {
            flex: 1;
            padding: 0;
        }
        
        /* Smooth transitions */
        .btn {
            transition: all 0.3s ease;
            border-radius: 8px;
            font-weight: 500;
        }
        
        .btn:hover {
            transform: translateY(-1px);
        }
        
        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 6px;
        }
        
        ::-webkit-scrollbar-track {
            background: var(--bg-secondary);
        }
        
        ::-webkit-scrollbar-thumb {
            background: var(--accent-color);
            border-radius: 3px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: #1e4a9a;
        }
    </style>
</head>
<body class="app-container">
    <!-- Main Content -->
    <main class="app-content">
        @yield('content')
    </main>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Theme Toggle Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const html = document.documentElement;
            
            // Get saved theme or default to 'dark'
            let currentTheme = localStorage.getItem('theme') || 'dark';
            
            // Apply saved theme
            applyTheme(currentTheme);
            
            function applyTheme(theme) {
                if (theme === 'light') {
                    html.setAttribute('data-theme', 'light');
                } else {
                    html.removeAttribute('data-theme');
                }
            }
            
            // Listen for system theme changes
            if (window.matchMedia) {
                window.matchMedia('(prefers-color-scheme: light)').addEventListener('change', function(e) {
                    if (currentTheme === 'auto') {
                        applyTheme(e.matches ? 'light' : 'dark');
                    }
                });
            }
        });
        
        // PWA Service Worker Registration
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('/sw.js')
                    .then(function(registration) {
                        console.log('Service Worker registered successfully:', registration.scope);
                    })
                    .catch(function(error) {
                        console.log('Service Worker registration failed:', error);
                    });
            });
        }
    </script>
    @include('components.chat-fab')
</body>
</html>

