@extends('layouts.app')

@section('title', 'Install Mews AI App')

@section('content')
<div class="mobile-page">
    <!-- Page Header -->
    <div class="page-header">
        <div class="header-content">
            <a href="{{ route('home') }}" class="back-button">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div class="header-text">
                <h1 class="page-title">Install App</h1>
                <p class="page-subtitle">Get the full app experience</p>
            </div>
        </div>
    </div>

    <!-- PWA Install Content -->
    <div class="page-content">
        <div class="pwa-install-container">
            <!-- App Preview -->
            <div class="app-preview">
                <div class="phone-mockup">
                    <div class="phone-screen">
                        <div class="app-header">
                            <div class="app-icon">
                                <i class="fas fa-newspaper"></i>
                            </div>
                            <div class="app-title">Mews AI</div>
                        </div>
                        <div class="app-content">
                            <div class="feature-demo">
                                <i class="fas fa-robot"></i>
                                <span>AI Chat</span>
                            </div>
                            <div class="feature-demo">
                                <i class="fas fa-bookmark"></i>
                                <span>Bookmarks</span>
                            </div>
                            <div class="feature-demo">
                                <i class="fas fa-history"></i>
                                <span>History</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Benefits -->
            <div class="benefits-section">
                <h3 class="section-title">
                    <i class="fas fa-star"></i>
                    Why Install the App?
                </h3>
                
                <div class="benefits-list">
                    <div class="benefit-item">
                        <div class="benefit-icon">
                            <i class="fas fa-rocket"></i>
                        </div>
                        <div class="benefit-content">
                            <h4>Faster Loading</h4>
                            <p>Instant access with cached content and offline reading</p>
                        </div>
                    </div>
                    
                    <div class="benefit-item">
                        <div class="benefit-icon">
                            <i class="fas fa-bell"></i>
                        </div>
                        <div class="benefit-content">
                            <h4>Push Notifications</h4>
                            <p>Get notified about breaking news and trending stories</p>
                        </div>
                    </div>
                    
                    <div class="benefit-item">
                        <div class="benefit-icon">
                            <i class="fas fa-mobile-alt"></i>
                        </div>
                        <div class="benefit-content">
                            <h4>App-like Experience</h4>
                            <p>Full-screen mode with native app feel</p>
                        </div>
                    </div>
                    
                    <div class="benefit-item">
                        <div class="benefit-icon">
                            <i class="fas fa-wifi-slash"></i>
                        </div>
                        <div class="benefit-content">
                            <h4>Offline Access</h4>
                            <p>Read cached articles even without internet</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Installation Instructions -->
            <div class="install-instructions">
                <h3 class="section-title">
                    <i class="fas fa-download"></i>
                    How to Install
                </h3>
                
                <div class="instructions-grid">
                    <div class="instruction-step">
                        <div class="step-number">1</div>
                        <div class="step-content">
                            <h4>Look for Install Button</h4>
                            <p>Click the "Install App" button in your browser or the floating install button</p>
                        </div>
                    </div>
                    
                    <div class="instruction-step">
                        <div class="step-number">2</div>
                        <div class="step-content">
                            <h4>Confirm Installation</h4>
                            <p>Click "Install" in the browser prompt to add the app to your device</p>
                        </div>
                    </div>
                    
                    <div class="instruction-step">
                        <div class="step-number">3</div>
                        <div class="step-content">
                            <h4>Launch from Home Screen</h4>
                            <p>Find the Mews AI icon on your home screen and tap to launch</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Manual Install Button -->
            <div class="manual-install">
                <button id="manualInstallBtn" class="btn btn-primary btn-lg">
                    <i class="fas fa-download"></i>
                    Install Mews AI App
                </button>
                <p class="install-note">
                    If you don't see the install button, your browser may not support PWA installation.
                </p>
            </div>
        </div>
    </div>
</div>

<style>
/* PWA Install Styles */
.pwa-install-container {
    display: flex;
    flex-direction: column;
    gap: 2rem;
}

/* App Preview */
.app-preview {
    display: flex;
    justify-content: center;
    margin-bottom: 1rem;
}

.phone-mockup {
    width: 200px;
    height: 400px;
    background: #333;
    border-radius: 25px;
    padding: 20px 15px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
}

.phone-screen {
    width: 100%;
    height: 100%;
    background: var(--bg-primary);
    border-radius: 15px;
    overflow: hidden;
    display: flex;
    flex-direction: column;
}

.app-header {
    background: var(--accent-gradient);
    color: white;
    padding: 1rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.app-icon {
    width: 30px;
    height: 30px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.app-title {
    font-weight: 600;
    font-size: 1.1rem;
}

.app-content {
    flex: 1;
    padding: 1rem;
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.feature-demo {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem;
    background: var(--bg-secondary);
    border-radius: 8px;
    border: 1px solid var(--border-color);
}

.feature-demo i {
    color: var(--accent-color);
    font-size: 1.2rem;
}

/* Benefits Section */
.benefits-section {
    background: var(--bg-secondary);
    border-radius: 16px;
    border: 1px solid var(--border-color);
    padding: 1.5rem;
}

.benefits-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.benefit-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
}

.benefit-icon {
    width: 40px;
    height: 40px;
    background: var(--accent-gradient);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
    flex-shrink: 0;
}

.benefit-content h4 {
    font-size: 1rem;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 0.25rem 0;
}

.benefit-content p {
    font-size: 0.9rem;
    color: var(--text-secondary);
    margin: 0;
    line-height: 1.4;
}

/* Installation Instructions */
.install-instructions {
    background: var(--bg-secondary);
    border-radius: 16px;
    border: 1px solid var(--border-color);
    padding: 1.5rem;
}

.instructions-grid {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.instruction-step {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
}

.step-number {
    width: 32px;
    height: 32px;
    background: var(--accent-gradient);
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 0.9rem;
    flex-shrink: 0;
}

.step-content h4 {
    font-size: 1rem;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 0.25rem 0;
}

.step-content p {
    font-size: 0.9rem;
    color: var(--text-secondary);
    margin: 0;
    line-height: 1.4;
}

/* Manual Install */
.manual-install {
    text-align: center;
    padding: 2rem 1rem;
    background: var(--bg-secondary);
    border-radius: 16px;
    border: 1px solid var(--border-color);
}

.manual-install .btn {
    margin-bottom: 1rem;
}

.install-note {
    font-size: 0.85rem;
    color: var(--text-secondary);
    margin: 0;
}

/* Responsive Design */
@media (max-width: 480px) {
    .phone-mockup {
        width: 160px;
        height: 320px;
        padding: 15px 10px;
    }
    
    .app-header {
        padding: 0.75rem;
    }
    
    .app-content {
        padding: 0.75rem;
    }
}

@media (min-width: 768px) {
    .pwa-install-container {
        max-width: 600px;
        margin: 0 auto;
    }
    
    .benefits-list {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 1.5rem;
    }
    
    .instructions-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 2rem;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const manualInstallBtn = document.getElementById('manualInstallBtn');
    
    // Check if PWA is already installed
    if (window.matchMedia('(display-mode: standalone)').matches) {
        manualInstallBtn.innerHTML = '<i class="fas fa-check"></i> App Already Installed';
        manualInstallBtn.disabled = true;
        manualInstallBtn.style.background = '#28a745';
    }
    
    // Manual install button
    manualInstallBtn.addEventListener('click', function() {
        if ('serviceWorker' in navigator) {
            // Try to trigger install prompt
            if (window.deferredPrompt) {
                window.deferredPrompt.prompt();
                window.deferredPrompt.userChoice.then(function(choiceResult) {
                    if (choiceResult.outcome === 'accepted') {
                        console.log('User accepted the install prompt');
                        manualInstallBtn.innerHTML = '<i class="fas fa-check"></i> Installing...';
                        manualInstallBtn.disabled = true;
                    }
                    window.deferredPrompt = null;
                });
            } else {
                // Show instructions for manual installation
                alert('To install this app:\n\n1. Look for the "Add to Home Screen" option in your browser menu\n2. Or look for an install icon in your browser address bar\n3. Follow the prompts to install the app');
            }
        } else {
            alert('Your browser does not support PWA installation. Please use a modern browser like Chrome, Firefox, or Safari.');
        }
    });
    
    // Listen for install prompt
    window.addEventListener('beforeinstallprompt', function(e) {
        e.preventDefault();
        window.deferredPrompt = e;
        manualInstallBtn.style.display = 'block';
    });
    
    // Listen for successful installation
    window.addEventListener('appinstalled', function(e) {
        console.log('PWA was installed');
        manualInstallBtn.innerHTML = '<i class="fas fa-check"></i> App Installed Successfully!';
        manualInstallBtn.disabled = true;
        manualInstallBtn.style.background = '#28a745';
    });
});
</script>
@endsection

