@extends('layouts.user-dashboard')

@section('title', 'Dashboard')

@section('content')
<div class="mobile-dashboard">
    <!-- Success Message -->
    @if(session('success'))
        <div class="alert alert-success" id="success-message" style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 8px; margin: 1rem; border: 1px solid #c3e6cb; position: fixed; top: 20px; left: 20px; right: 20px; z-index: 1000; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
            <i class="fas fa-check-circle"></i> {{ session('success') }}
        </div>
    @endif

    @if($errors->any())
        <div class="alert alert-danger" id="error-message" style="background: #f8d7da; color: #721c24; padding: 1rem; border-radius: 8px; margin: 1rem; border: 1px solid #f5c6cb; position: fixed; top: 20px; left: 20px; right: 20px; z-index: 1000; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
            <i class="fas fa-exclamation-circle"></i> 
            <ul style="margin: 0; padding-left: 1rem;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Mobile Header -->
    <div class="dashboard-header">
        <!-- Back Button -->
        <div class="back-button-container">
            <a href="{{ url('/') }}" class="back-button">
                <i class="fas fa-arrow-left"></i>
                <span>Back to News</span>
            </a>
        </div>
        
        <div class="welcome-section">
            <div class="user-info">
                @if($user->profile)
                    <img src="{{ $user->profile->avatar_url }}" 
                         alt="Profile Picture" 
                         class="profile-avatar">
                @else
                    <div class="profile-avatar-placeholder">
                        {{ substr($user->name, 0, 1) }}
                    </div>
                @endif
                <div class="user-details">
                    <h2 class="welcome-text">Welcome back,</h2>
                    <h1 class="user-name">{{ $user->display_name }}</h1>
                    @if($user->profile && $user->profile->bio)
                        <p class="user-bio">{{ $user->profile->bio }}</p>
                    @endif
                    <!-- Reading Stats in Profile Card -->
                    <div class="profile-stats">
                        <div class="stat-item">
                            <span class="stat-number">{{ $stats['total_articles_read'] }}</span>
                            <span class="stat-label">Articles Read</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">{{ $stats['articles_this_week'] }}</span>
                            <span class="stat-label">This Week</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Recent Activity -->
    <div class="recent-activity">
        <h3 class="section-title">Recent Activity</h3>
        
        <!-- Recent Reading History -->
        <div class="activity-section">
            <div class="activity-header">
                <h4 class="activity-title">
                    <i class="fas fa-history"></i>
                    Reading History
                </h4>
                <a href="{{ route('user.reading-history') }}" class="view-all-link">View All</a>
            </div>
            <div class="activity-content">
                @if($recentHistory->count() > 0)
                    <div class="activity-list">
                        @foreach($recentHistory as $item)
                            <a href="{{ route('news.deep-dive.show', ['article_id' => $item->article_id]) }}" class="activity-item clickable">
                                <div class="activity-icon">
                                    <i class="fas fa-newspaper"></i>
                                </div>
                                <div class="activity-details">
                                    <div class="activity-title-text">{{ $item->article_title }}</div>
                                    <div class="activity-meta">
                                        <span class="activity-category">{{ $item->article_subcategory ?? $item->article_category }}</span>
                                        <span class="activity-time">{{ $item->read_at->diffForHumans() }}</span>
                                    </div>
                                </div>
                            </a>
                        @endforeach
                    </div>
                @else
                    <div class="empty-state">
                        <i class="fas fa-newspaper"></i>
                        <p>No reading history yet</p>
                        <small>Start exploring articles to see your history here</small>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Settings Section -->
    <div class="settings-section">
        <h3 class="section-title">
            <i class="fas fa-cog"></i>
            Settings & Preferences
        </h3>
        
        <div class="settings-grid">
            <!-- Theme Settings -->
            <div class="setting-card">
                <div class="setting-header">
                    <div class="setting-icon">
                        <i class="fas fa-palette"></i>
                    </div>
                    <div class="setting-info">
                        <h4 class="setting-title">Theme</h4>
                        <p class="setting-description">Customize your app appearance</p>
                    </div>
                </div>
                <div class="setting-actions">
                    <div class="theme-toggle-inline">
                        <button class="theme-toggle-btn" id="dashboardThemeToggle">
                            <i class="fas fa-moon" id="dashboardThemeIcon"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Profile Settings -->
            <a href="{{ route('user.profile.edit') }}" class="setting-card clickable">
                <div class="setting-header">
                    <div class="setting-icon">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="setting-info">
                        <h4 class="setting-title">Profile</h4>
                        <p class="setting-description">Manage your personal information</p>
                    </div>
                </div>
                <div class="setting-actions">
                    <i class="fas fa-chevron-right"></i>
                </div>
            </a>

            <!-- Preferences -->
            <a href="{{ route('user.preferences.edit') }}" class="setting-card clickable">
                <div class="setting-header">
                    <div class="setting-icon">
                        <i class="fas fa-sliders-h"></i>
                    </div>
                    <div class="setting-info">
                        <h4 class="setting-title">Preferences</h4>
                        <p class="setting-description">Customize your reading experience</p>
                    </div>
                </div>
                <div class="setting-actions">
                    <i class="fas fa-chevron-right"></i>
                </div>
            </a>

            <!-- App Settings -->
            <a href="{{ route('pwa.install') }}" class="setting-card clickable">
                <div class="setting-header">
                    <div class="setting-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <div class="setting-info">
                        <h4 class="setting-title">Install App</h4>
                        <p class="setting-description">Get the full app experience</p>
                    </div>
                </div>
                <div class="setting-actions">
                    <i class="fas fa-chevron-right"></i>
                </div>
            </a>

            <!-- Logout -->
            <div class="setting-card logout-card">
                <div class="setting-header">
                    <div class="setting-icon">
                        <i class="fas fa-sign-out-alt"></i>
                    </div>
                    <div class="setting-info">
                        <h4 class="setting-title">Sign Out</h4>
                        <p class="setting-description">Log out of your account</p>
                    </div>
                </div>
                <div class="setting-actions">
                    <form method="POST" action="{{ route('logout') }}" class="d-inline" id="logoutForm">
                        @csrf
                        <button type="submit" class="logout-btn" id="logoutBtn">
                            <span class="btn-text">
                                <i class="fas fa-sign-out-alt"></i>
                            </span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div id="loadingOverlay" class="loading-overlay">
    <div class="loading-content">
        <div class="loading-spinner"></div>
        <div class="loading-text" id="loadingText">Loading...</div>
    </div>
</div>

<script>
// Loading indicator functions
function showLoading(message = 'Loading...') {
    const overlay = document.getElementById('loadingOverlay');
    const text = document.getElementById('loadingText');
    text.textContent = message;
    overlay.classList.add('show');
}

function hideLoading() {
    const overlay = document.getElementById('loadingOverlay');
    overlay.classList.remove('show');
}

function setButtonLoading(button, loading = true) {
    if (loading) {
        button.classList.add('btn-loading');
        button.disabled = true;
        const text = button.querySelector('.btn-text');
        if (text) {
            text.style.opacity = '0';
        }
    } else {
        button.classList.remove('btn-loading');
        button.disabled = false;
        const text = button.querySelector('.btn-text');
        if (text) {
            text.style.opacity = '1';
        }
    }
}

// Handle logout form submission
document.addEventListener('DOMContentLoaded', function() {
    const logoutForm = document.getElementById('logoutForm');
    const logoutBtn = document.getElementById('logoutBtn');
    
    if (logoutForm && logoutBtn) {
        logoutForm.addEventListener('submit', function(e) {
            // Show loading state
            setButtonLoading(logoutBtn, true);
            showLoading('Signing out...');
            
            // The form will submit normally, but we show loading feedback
        });
    }
});
</script>

<style>
/* Mobile Dashboard Styles */
.mobile-dashboard {
    padding: 1rem;
    max-width: 100%;
    margin: 0 auto;
}

/* Dashboard Header */
.dashboard-header {
    margin-bottom: 2rem;
}

/* Back Button */
.back-button-container {
    margin-bottom: 1rem;
}

.back-button {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1rem;
    background: var(--bg-secondary);
    color: var(--text-primary);
    text-decoration: none;
    border-radius: 12px;
    border: 1px solid var(--border-color);
    font-size: 0.9rem;
    font-weight: 500;
    transition: all 0.2s ease;
    box-shadow: var(--card-shadow);
}

.back-button:hover {
    background: var(--bg-hover);
    color: var(--text-primary);
    text-decoration: none;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.back-button i {
    font-size: 0.8rem;
    opacity: 0.8;
}

.back-button span {
    font-size: 0.9rem;
}

.welcome-section {
    background: var(--bg-secondary);
    border-radius: 16px;
    padding: 1.5rem;
    border: 1px solid var(--border-color);
    box-shadow: var(--card-shadow);
}

.user-info {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.profile-avatar {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid var(--accent-color);
}

.profile-avatar-placeholder {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: var(--accent-gradient);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 24px;
    font-weight: 600;
    border: 3px solid var(--border-color);
}

.user-details {
    flex: 1;
}

.welcome-text {
    font-size: 0.9rem;
    color: var(--text-secondary);
    margin: 0;
    font-weight: 400;
}

.user-name {
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0.25rem 0;
    background: var(--accent-gradient);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.user-bio {
    font-size: 0.9rem;
    color: var(--text-secondary);
    margin: 0.5rem 0 0 0;
    line-height: 1.4;
}

/* Profile Stats */
.profile-stats {
    display: flex;
    gap: 1.5rem;
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid var(--border-color);
}

.stat-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
}

.stat-item .stat-number {
    font-size: 1.25rem;
    font-weight: 700;
    color: var(--accent-color);
    line-height: 1;
}

.stat-item .stat-label {
    font-size: 0.75rem;
    color: var(--text-secondary);
    margin-top: 0.25rem;
    font-weight: 500;
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: var(--bg-secondary);
    border-radius: 12px;
    padding: 1.25rem;
    border: 1px solid var(--border-color);
    box-shadow: var(--card-shadow);
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 1rem;
}

.stat-card:hover {
    transform: translateY(-2px);
    box-shadow: var(--card-shadow-hover);
}

.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    background: var(--accent-gradient);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 20px;
}

.stat-content {
    flex: 1;
}

.stat-number {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--text-primary);
    line-height: 1;
}

.stat-label {
    font-size: 0.8rem;
    color: var(--text-secondary);
    margin-top: 0.25rem;
}

.section-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}


/* Recent Activity */
.recent-activity {
    margin-bottom: 2rem;
}

.activity-section {
    background: var(--bg-secondary);
    border-radius: 16px;
    border: 1px solid var(--border-color);
    box-shadow: var(--card-shadow);
    margin-bottom: 1.5rem;
    overflow: hidden;
}

.activity-header {
    padding: 1.25rem 1.5rem;
    border-bottom: 1px solid var(--border-color);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.activity-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.view-all-link {
    color: var(--accent-color);
    text-decoration: none;
    font-size: 0.9rem;
    font-weight: 500;
    transition: all 0.3s ease;
}

.view-all-link:hover {
    color: var(--text-primary);
    text-decoration: none;
}

.activity-content {
    padding: 0;
}

.activity-list {
    padding: 0;
}

.activity-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.5rem;
    border-bottom: 1px solid var(--border-color);
    transition: all 0.3s ease;
}

.activity-item:last-child {
    border-bottom: none;
}

.activity-item:hover {
    background: rgba(255, 107, 53, 0.05);
}

/* Clickable Elements */
.clickable {
    text-decoration: none;
    color: inherit;
    display: block;
    transition: all 0.3s ease;
}

.clickable:hover {
    text-decoration: none;
    color: inherit;
    transform: translateY(-1px);
}

.activity-item.clickable:hover {
    background: rgba(255, 107, 53, 0.08);
    transform: translateY(-1px);
}

.activity-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: var(--accent-gradient);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 16px;
    flex-shrink: 0;
}

.activity-details {
    flex: 1;
    min-width: 0;
}

.activity-title-text {
    font-size: 0.95rem;
    font-weight: 500;
    color: var(--text-primary);
    line-height: 1.3;
    margin-bottom: 0.25rem;
}

.activity-meta {
    display: flex;
    gap: 0.5rem;
    align-items: center;
}

.activity-category {
    font-size: 0.8rem;
    color: var(--accent-color);
    background: rgba(255, 107, 53, 0.1);
    padding: 0.25rem 0.5rem;
    border-radius: 4px;
    font-weight: 500;
}

.activity-time {
    font-size: 0.8rem;
    color: var(--text-secondary);
}


.activity-actions {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    flex-shrink: 0;
}

/* Empty State */
.empty-state {
    padding: 3rem 1.5rem;
    text-align: center;
    color: var(--text-secondary);
}

.empty-state i {
    font-size: 3rem;
    color: var(--accent-color);
    margin-bottom: 1rem;
    opacity: 0.5;
}

.empty-state p {
    font-size: 1.1rem;
    font-weight: 500;
    margin-bottom: 0.5rem;
}

.empty-state small {
    font-size: 0.9rem;
    opacity: 0.8;
}

/* Responsive Design */
@media (max-width: 480px) {
    .mobile-dashboard {
        padding: 0.75rem;
    }
    
    .back-button {
        padding: 0.6rem 0.8rem;
        font-size: 0.85rem;
    }
    
    .back-button span {
        font-size: 0.85rem;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
        gap: 0.75rem;
    }
    
    
    .user-info {
        flex-direction: column;
        text-align: center;
        gap: 1rem;
    }
    
    .profile-avatar,
    .profile-avatar-placeholder {
        width: 80px;
        height: 80px;
        font-size: 32px;
    }
    
    .user-name {
        font-size: 1.25rem;
    }
    
    .activity-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.75rem;
    }
    
    .activity-actions {
        align-self: flex-end;
    }
}

@media (min-width: 768px) {
    .mobile-dashboard {
        max-width: 600px;
        margin: 0 auto;
    }
    
    .stats-grid {
        grid-template-columns: repeat(4, 1fr);
    }
    
}

/* Settings Section Styles */
.settings-section {
    margin-top: 2rem;
}

.settings-grid {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.setting-card {
    background: var(--bg-secondary);
    border-radius: 16px;
    border: 1px solid var(--border-color);
    padding: 1.25rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
    transition: all 0.3s ease;
    box-shadow: var(--card-shadow);
}

.setting-card:hover {
    transform: translateY(-2px);
    box-shadow: var(--card-shadow-hover);
}

.setting-card.clickable {
    text-decoration: none;
    color: inherit;
}

.setting-card.clickable:hover {
    text-decoration: none;
    color: inherit;
}

.setting-card.logout-card {
    border-color: #dc3545;
    background: rgba(220, 53, 69, 0.05);
}

.setting-card.logout-card:hover {
    background: rgba(220, 53, 69, 0.1);
}

.setting-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    flex: 1;
}

.setting-icon {
    width: 44px;
    height: 44px;
    background: var(--accent-gradient);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.logout-card .setting-icon {
    background: #dc3545;
}

.setting-info {
    flex: 1;
}

.setting-title {
    font-size: 1rem;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 0.25rem 0;
}

.setting-description {
    font-size: 0.85rem;
    color: var(--text-secondary);
    margin: 0;
    line-height: 1.3;
}

.setting-actions {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.setting-actions i.fa-chevron-right {
    color: var(--text-secondary);
    font-size: 0.9rem;
    transition: all 0.3s ease;
}

.setting-card.clickable:hover .setting-actions i.fa-chevron-right {
    color: var(--accent-color);
    transform: translateX(2px);
}

.setting-link {
    width: 40px;
    height: 40px;
    background: var(--bg-primary);
    border: 1px solid var(--border-color);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--text-primary);
    text-decoration: none;
    transition: all 0.3s ease;
}

.setting-link:hover {
    background: var(--accent-gradient);
    color: white;
    text-decoration: none;
    transform: scale(1.05);
}

.theme-toggle-inline {
    display: flex;
    align-items: center;
}

.theme-toggle-btn {
    width: 48px;
    height: 24px;
    background: var(--border-color);
    border: none;
    border-radius: 12px;
    position: relative;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
}

.theme-toggle-btn:hover {
    background: var(--accent-color);
}

.theme-toggle-btn i {
    color: white;
    font-size: 0.8rem;
    transition: all 0.3s ease;
}

.logout-btn {
    width: 40px;
    height: 40px;
    background: #dc3545;
    border: none;
    border-radius: 10px;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s ease;
}

        .logout-btn:hover {
            background: #c82333;
            transform: scale(1.05);
        }
        
        /* Loading Indicators */
        .loading-spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
            margin-right: 8px;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        .btn-loading {
            opacity: 0.7;
            pointer-events: none;
            position: relative;
        }
        
        .btn-loading::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 16px;
            height: 16px;
            margin: -8px 0 0 -8px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
        }
        
        .btn-loading .btn-text {
            opacity: 0;
        }
        
        /* Subtle loading overlay */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(2px);
            z-index: 9999;
            display: none;
            align-items: center;
            justify-content: center;
        }
        
        .loading-overlay.show {
            display: flex;
        }
        
        .loading-content {
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            box-shadow: var(--card-shadow);
        }
        
        .loading-content .loading-spinner {
            width: 24px;
            height: 24px;
            margin: 0 0 12px 0;
        }
        
        .loading-content .loading-text {
            color: var(--text-primary);
            font-size: 14px;
            font-weight: 500;
        }

/* Responsive Design for Settings */
@media (max-width: 480px) {
    .setting-card {
        padding: 1rem;
    }
    
    .setting-icon {
        width: 40px;
        height: 40px;
        font-size: 1.1rem;
    }
    
    .setting-title {
        font-size: 0.95rem;
    }
    
    .setting-description {
        font-size: 0.8rem;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const themeToggle = document.getElementById('dashboardThemeToggle');
    const themeIcon = document.getElementById('dashboardThemeIcon');
    const html = document.documentElement;
    
    // Get saved theme or default to 'light'
    let currentTheme = localStorage.getItem('theme') || 'light';
    
    // Apply saved theme
    applyTheme(currentTheme);
    
    // Theme toggle functionality
    themeToggle.addEventListener('click', function() {
        currentTheme = currentTheme === 'dark' ? 'light' : 'dark';
        applyTheme(currentTheme);
        localStorage.setItem('theme', currentTheme);
        
        // Update user preference if logged in
        updateUserTheme(currentTheme);
    });
    
    function applyTheme(theme) {
        if (theme === 'light') {
            html.setAttribute('data-theme', 'light');
            themeIcon.className = 'fas fa-sun';
            themeToggle.title = 'Switch to Dark Mode';
        } else {
            html.removeAttribute('data-theme');
            themeIcon.className = 'fas fa-moon';
            themeToggle.title = 'Switch to Light Mode';
        }
    }
    
    function updateUserTheme(theme) {
        // Send theme update to server
        fetch('{{ route("user.preferences.update") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                theme: theme
            })
        }).then(response => response.json())
        .then(data => {
            if (data.success) {
                console.log('Theme preference updated successfully');
            }
        }).catch(error => {
            console.log('Theme preference update failed:', error);
        });
    }
    
    // Listen for system theme changes
    if (window.matchMedia) {
        window.matchMedia('(prefers-color-scheme: light)').addEventListener('change', function(e) {
            if (currentTheme === 'auto') {
                applyTheme(e.matches ? 'light' : 'dark');
            }
        });
    }
    
    // Auto-hide success/error messages
    const successMessage = document.getElementById('success-message');
    const errorMessage = document.getElementById('error-message');
    
    if (successMessage) {
        setTimeout(() => {
            successMessage.style.opacity = '0';
            successMessage.style.transition = 'opacity 0.5s ease';
            setTimeout(() => {
                successMessage.remove();
            }, 500);
        }, 3000);
    }
    
    if (errorMessage) {
        setTimeout(() => {
            errorMessage.style.opacity = '0';
            errorMessage.style.transition = 'opacity 0.5s ease';
            setTimeout(() => {
                errorMessage.remove();
            }, 500);
        }, 5000);
    }
});
</script>
@endsection


