<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\NewsChatbotController;
use App\Http\Controllers\AdController;
use App\Http\Controllers\DeepDiveController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Chat API route (no CSRF protection needed)
Route::post('/chat', [NewsChatbotController::class, 'chat'])->name('api.chat');


// News API routes
Route::get('/news', function(\Illuminate\Http\Request $request) {
    try {
        $limit = $request->get('limit', 20);
        $category = $request->get('category');
        $search = $request->get('q');
        
        $query = \DB::connection('crawler')
            ->table('vw_crawler_mews')
            ->select('post_id as id', 'post_title', 'post_content', 'sub_category as post_category', 'post_source', 'source', 'image as post_image', 'date_added', 'views')
            ->where('post_title', '!=', '')
            ->orderBy('date_added', 'desc');
        
        if ($category) {
            $query->where('sub_category', 'like', '%' . $category . '%');
        }
        
        if ($search) {
            $query->where(function($q) use ($search) {
                $q->where('post_title', 'like', '%' . $search . '%')
                  ->orWhere('post_content', 'like', '%' . $search . '%')
                  ->orWhere('post_excerpt', 'like', '%' . $search . '%');
            });
        }
        
        $articles = $query->limit($limit)->get();
        
        return response()->json([
            'success' => true,
            'data' => $articles,
            'count' => $articles->count()
        ]);
        
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'error' => 'Failed to fetch news: ' . $e->getMessage()
        ], 500);
    }
})->name('api.news');

Route::get('/news/categories', function() {
    try {
        $categories = \DB::connection('crawler')
            ->table('vw_crawler_mews')
            ->select('sub_category')
            ->whereNotNull('sub_category')
            ->where('sub_category', '!=', '')
            ->distinct()
            ->pluck('sub_category')
            ->filter()
            ->values();
        
        return response()->json([
            'success' => true,
            'data' => $categories
        ]);
        
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'error' => 'Failed to fetch categories: ' . $e->getMessage()
        ], 500);
    }
})->name('api.news.categories');

// Deep Dive API routes
Route::get('/news/deep-dive/{articleId}', [DeepDiveController::class, 'getArticle'])->name('api.deep-dive.get');
Route::post('/news/deep-dive/{articleId}/chat', [DeepDiveController::class, 'chat'])->name('api.deep-dive.chat');

// Ad API routes
Route::get('/ads', [AdController::class, 'getActiveAds'])->name('api.ads');
Route::get('/ads/chatbot', [AdController::class, 'getActiveAds'])->name('api.ads.chatbot');
Route::post('/ads/{id}/click', [AdController::class, 'trackClick'])->name('api.ads.click');
